package com.biz.crm.pricesetting.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.mdm.PriceSettingStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceProductUnitRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 价格维护主表
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Slf4j
@RestController
@RequestMapping("/mdmPriceSettingController")
@Api(tags = "价格维护主表 ")
@CrmGlobalLog
public class MdmPriceSettingController {
    @Autowired
    private IMdmPriceSettingService mdmPriceSettingService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmPriceSettingRespVo>> list(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        PageResult<MdmPriceSettingRespVo> result = mdmPriceSettingService.findList(mdmPriceSettingReqVo);
        return Result.ok(result);
    }

    @ApiOperation("校验当前时间是否会发生截断")
    @PostMapping("/checkTruncationTime")
    public Result<Boolean> checkTruncationTime(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        return Result.ok(mdmPriceSettingService.checkTimeTruncation(mdmPriceSettingReqVo));
    }

    @ApiOperation("根据维度查询唯一价格,多条返回错误信息")
    @PostMapping("/queryUnique")
    public Result<MdmPriceSettingRespVo> queryUnique(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        MdmPriceSettingRespVo respVo = mdmPriceSettingService.queryUnique(mdmPriceSettingReqVo);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmPriceSettingRespVo> query(@RequestParam("id") String id) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setId(id);
        MdmPriceSettingRespVo respVo = mdmPriceSettingService.query(mdmPriceSettingReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        mdmPriceSettingService.save(mdmPriceSettingReqVo);
        return Result.ok();
    }


    /**
     * 新增时校验时间交叉
     */
    @ApiOperation(value = "新增时间交叉校验")
    @PostMapping("/checkDate")
    public Result checkDate(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        Boolean result = mdmPriceSettingService.checkDate(mdmPriceSettingReqVo);
        return Result.ok(result);
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        mdmPriceSettingService.update(mdmPriceSettingReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        mdmPriceSettingService.deleteBatch(mdmPriceSettingReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        mdmPriceSettingService.enableBatch(mdmPriceSettingReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        mdmPriceSettingService.disableBatch(mdmPriceSettingReqVo);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "客户下拉框")
    @PostMapping("/findCustomerSelectList")
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(mdmPriceSettingService.findCustomerSelectList(mdmCustomerMsgReqVo));
    }

    @ApiOperation("商品下拉框")
    @PostMapping("/findProductSelectList")
    @CrmDictMethod
    public Result<List<MdmProductRespVo>> findProductSelectList(@RequestBody MdmProductReqVo mdmProductReqVo) {
        return Result.ok(mdmPriceSettingService.findProductSelectList(mdmProductReqVo));
    }

    @ApiOperation("客户价格查询")
    @PostMapping("/search")
    public Result<Map<String, Map<String, MdmPriceResp>>> search(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        Map<String, Map<String, MdmPriceResp>> map=mdmPriceSettingService.search(mdmPriceSearchReqVo);
        return Result.ok(map);
    }

    @ApiOperation("询价")
    @PostMapping("/inquiry")
    public Result<Map<String, Map<String, MdmPriceResp>>> inquiry(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        return Result.ok(mdmPriceSettingService.inquiry(mdmPriceSearchReqVo));
    }

}
