package com.biz.crm.pricesetting.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupEntity;
import com.biz.crm.pricesetting.provider.MdmPriceConditionProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 条件字段分类主表
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
public interface MdmPriceConditionGroupMapper extends BaseMapper<MdmPriceConditionGroupEntity> {

    /**
     * 列表
     *
     * @param page
     * @param mdmPriceConditionGroupReqVo
     * @return
     */
    List<MdmPriceConditionGroupRespVo> findList(Page<MdmPriceConditionGroupRespVo> page,
                                                @Param("vo") MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);
    /**
     * 列表(provider)
     *
     * @param page
     * @param mdmPriceConditionGroupReqVo
     * @return
     */
    @SelectProvider(type = MdmPriceConditionProvider.class,method = "findListGroup")
    List<MdmPriceConditionGroupRespVo> findListGroup(Page<MdmPriceConditionGroupRespVo> page,
                                                @Param("vo") MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

}
