package com.biz.crm.pricesetting.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchQueryVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.provider.MdmPriceConditionProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 价格维护主表 
 * 
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
public interface MdmPriceSettingMapper extends BaseMapper<MdmPriceSettingEntity> {
    /**
     * 列表
     * @param page
     * @param mdmPriceSettingReqVo
     * @return
     */
    List<MdmPriceSettingRespVo> findList(Page<MdmPriceSettingRespVo> page, @Param("vo") MdmPriceSettingReqVo mdmPriceSettingReqVo
           );

    /**
     * 列表（provider）
     * @param page
     * @param mdmPriceSettingReqVo
     * @return
     */
    @SelectProvider(type = MdmPriceConditionProvider.class,method = "findListSetting")
    List<MdmPriceSettingRespVo> findListSetting(Page<MdmPriceSettingRespVo> page, @Param("vo") MdmPriceSettingReqVo mdmPriceSettingReqVo);


    /**
     * 价格查询
     * @param mdmPriceSearchQueryVo vo
     * @return list
     */
    List<MdmPriceResp> search(@Param("vo") MdmPriceSearchQueryVo mdmPriceSearchQueryVo);
}
