package com.biz.crm.pricesetting.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author hej
 * @Created Date 2020-12-29
 **/
public class MdmPriceConditionProvider {

    public String findListGroup(Map<String,Object> map) {
        MdmPriceConditionGroupReqVo vo = (MdmPriceConditionGroupReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*");
            FROM("mdm_price_condition_group a");
            if (StringUtils.isNotEmpty(vo.getConditionGroupCode())) {
                WHERE("a.condition_group_code like " + ProviderUtil.bindPercent(vo.getConditionGroupCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getConditionGroupDesc())) {
                WHERE("a.condition_group_desc like " + ProviderUtil.bindPercent(vo.getConditionGroupDesc(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }

    public String findListType(Map<String,Object> map) {
        MdmPriceConditionTypeReqVo vo = (MdmPriceConditionTypeReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*");
            FROM("mdm_price_condition_type a");
            if (StringUtils.isNotEmpty(vo.getConditionTypeCode())) {
                WHERE("a.condition_type_code like " + ProviderUtil.bindPercent(vo.getConditionTypeCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getConditionTypeDesc())) {
                WHERE("a.condition_type_desc like " + ProviderUtil.bindPercent(vo.getConditionTypeDesc(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getConditionTypeType())) {
                WHERE("a.condition_type_type = #{vo.conditionTypeType}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }

    public String findListSetting(Map<String,Object> map) {
        MdmPriceSettingReqVo vo = (MdmPriceSettingReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*,b.condition_type_desc conditionTypeDesc,mpcg.condition_group_desc conditionGroupDesc");
            FROM("mdm_price_setting a");
            LEFT_OUTER_JOIN("mdm_price_condition_type b on a.condition_type_code = b.condition_type_code");
            LEFT_OUTER_JOIN("mdm_price_condition_group mpcg on a.condition_group_code = mpcg.condition_group_code");
            if (StringUtils.isNotEmpty(vo.getPriceSettingCode())) {
                WHERE("a.price_setting_code like " + ProviderUtil.bindPercent(vo.getPriceSettingCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getConditionTypeCode())) {
                WHERE("a.condition_type_code like " + ProviderUtil.bindPercent(vo.getConditionTypeCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getConditionTypeDesc())) {
                WHERE("b.condition_type_desc like " + ProviderUtil.bindPercent(vo.getConditionTypeDesc(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getOrgCode())) {
                WHERE("a.org_code like " + ProviderUtil.bindPercent(vo.getOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getOrgName())) {
                WHERE("a.org_name like " + ProviderUtil.bindPercent(vo.getOrgName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCustomerCode())) {
                WHERE("a.customer_code like " + ProviderUtil.bindPercent(vo.getCustomerCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCustomerName())) {
                WHERE("a.customer_name like " + ProviderUtil.bindPercent(vo.getCustomerName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getChannel())) {
                WHERE("a.channel = #{vo.channel}");
            }
            if (StringUtils.isNotEmpty(vo.getProductCode())) {
                WHERE("a.product_code like " + ProviderUtil.bindPercent(vo.getProductCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getProductName())) {
                WHERE("a.product_name like " + ProviderUtil.bindPercent(vo.getProductName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (!Objects.isNull(vo.getPrice())) {
                WHERE("a.price = #{vo.price}");
            }
            if (StringUtils.isNotEmpty(vo.getCurrencyType())) {
                WHERE("a.currency_type = #{vo.currencyType}");
            }
            if (StringUtils.isNotEmpty(vo.getBeginDate())) {
                WHERE("a.begin_date &gt;= #{vo.beginDate}");
            }
            if (StringUtils.isNotEmpty(vo.getEndDate())) {
                WHERE("a.end_date &lt;= #{vo.endDate}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }


}
