package com.biz.crm.pricesetting.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 价格维护主表 接口
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
public interface IMdmPriceSettingService extends IService<MdmPriceSettingEntity> {

    /**
     * 列表
     * @param mdmPriceSettingReqVo
     * @return PageResult<MdmPriceSettingRespVo>
     */
    PageResult<MdmPriceSettingRespVo> findList(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    Boolean checkTimeTruncation(MdmPriceSettingReqVo reqVo);

    /**
     * 查询
     * @param mdmPriceSettingReqVo
     * @return MdmPriceSettingRespVo
     */
    MdmPriceSettingRespVo query(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 新增
     * @param mdmPriceSettingReqVo
     * @return
     */
    void save(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 新增时时间校验
     * @param mdmPriceSettingReqVo
     * @return 是否有时间交叉
     */
    Boolean checkDate(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 更新
     * @param mdmPriceSettingReqVo
     * @return
     */
    void update(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 删除
     * @param mdmPriceSettingReqVo
     * @return
     */
    void deleteBatch(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 启用
     * @param mdmPriceSettingReqVo
     * @return
     */
    void enableBatch(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 禁用
     * @param mdmPriceSettingReqVo
     * @return
     */
    void disableBatch(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 通过商品code和经销商code查询商品价格
     * 该接口返回的map不能为null
     * 该接口返回的key 跟 goodsCodes长度一样，如果某商品没有价格则value为null
     * @param goodsCodes
     * @param cusCodes
     * @return key->商品code，value->价格
     */
    Map<String, BigDecimal> findPriceByGoodsAndCusCode(List<String> goodsCodes,String cusCodes);

    /**
     * 客户下拉框
     * @return list
     */
    List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 商品下拉框
     * @param mdmProductReqVo vo
     * @return list
     */
    List<MdmProductRespVo> findProductSelectList(MdmProductReqVo mdmProductReqVo);

    /**
     * 价格查询
     * @param mdmPriceSearchReqVo vo
     * @return map
     */
    Map<String, Map<String, MdmPriceResp>> search(MdmPriceSearchReqVo mdmPriceSearchReqVo);

    /**
     * 根据维度查询唯一价格,多条返回错误信息
     * @param mdmPriceSettingReqVo vo
     * @return vo
     */
    MdmPriceSettingRespVo queryUnique(MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 根据传参与维护查询价格
     * @param mdmPriceSettingReqVo vo
     * @return map
     */
    Map<String, Map<String, MdmPriceResp>> inquiry(MdmPriceSearchReqVo mdmPriceSearchReqVo);
}

