package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupRelFieldService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 条件字段分类和字段的关系表 接口实现
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmPriceConditionGroupRelFieldServiceExpandImpl")
public class MdmPriceConditionGroupRelFieldServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmPriceConditionGroupRelFieldMapper, MdmPriceConditionGroupRelFieldEntity> implements MdmPriceConditionGroupRelFieldService {

    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;

    @Override
    public Map<String, List<MdmPriceConditionGroupRelFieldRespVo>> getRelFieldGroupByGroupCodeList(List<String> conditionGroupCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(conditionGroupCodeList)) {
            List<MdmPriceConditionGroupRelFieldEntity> list = this.lambdaQuery()
                    .in(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, conditionGroupCodeList)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                return list.stream().map(item -> CrmBeanUtil.copy(item, MdmPriceConditionGroupRelFieldRespVo.class)).collect(Collectors.groupingBy(MdmPriceConditionGroupRelFieldRespVo::getConditionGroupCode));
            }
        }
        return new HashMap<>();
    }

    @Override
    public Map<String, List<String>> getFieldByGroupCodeList(List<String> conditionGroupCodeList) {
        if(CollectionUtils.isEmpty(conditionGroupCodeList)){
            return Collections.emptyMap();
        }
        return this.lambdaQuery()
                .in(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, conditionGroupCodeList)
                .select(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, MdmPriceConditionGroupRelFieldEntity::getFieldCode)
                .list()
                .stream()
                .filter(x->!StringUtils.isEmpty(x.getConditionGroupCode())&&!StringUtils.isEmpty(x.getFieldCode()))
                .collect(Collectors.groupingBy(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode
                        , Collectors.mapping(MdmPriceConditionGroupRelFieldEntity::getFieldCode, Collectors.toList())));
    }
}
