package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionTypeRelGroupMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupRelFieldService;
import com.biz.crm.pricesetting.service.MdmPriceConditionTypeRelGroupService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 条件字段类型和条件字段分类的关系表 接口实现
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmPriceConditionTypeRelGroupServiceExpandImpl")
public class MdmPriceConditionTypeRelGroupServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmPriceConditionTypeRelGroupMapper, MdmPriceConditionTypeRelGroupEntity> implements MdmPriceConditionTypeRelGroupService {

    @Resource
    private MdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;

    @Override
    public Map<String, List<String>> groupPriorityList(List<String> conditionTypeCodeList) {
        Map<String, List<String>> map = new HashMap<>();
        if (CollectionUtils.isEmpty(conditionTypeCodeList)) {
            return map;
        }
        List<MdmPriceConditionTypeRelGroupEntity> groupEntities = this.lambdaQuery()
                .in(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, conditionTypeCodeList)
                .list();
        log.info("根据字段类型编码集合查询所有条件分类:{}", groupEntities);
        if (CollectionUtils.isEmpty(groupEntities)) {
            return map;
        }
        //取排序最小的条件分类
        Map<String, MdmPriceConditionTypeRelGroupEntity> priorityGroupMap = groupEntities.stream()
                .collect(Collectors.toMap(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, Function.identity()
                        , BinaryOperator.minBy(Comparator.comparing(k -> Optional.ofNullable(k)
                                .map(MdmPriceConditionTypeRelGroupEntity::getSortNum)
                                .orElse(100)))));
        log.info("转换高优先级分类:{}", priorityGroupMap);
        Collection<MdmPriceConditionTypeRelGroupEntity> priorityGroups = priorityGroupMap.values();
        if (CollectionUtils.isEmpty(priorityGroups)) {
            return map;
        }
        List<String> groupList = priorityGroups.stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getConditionGroupCode()))
                .map(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode)
                .collect(Collectors.toList());
        Map<String, List<MdmPriceConditionGroupRelFieldRespVo>> groupFieldMap
                = mdmPriceConditionGroupRelFieldService.getRelFieldGroupByGroupCodeList(groupList);
        if (ObjectUtils.isEmpty(groupFieldMap)) {
            return map;
        }
        log.info("根据条件字段分类编码集合查询分类字段分组:{}", groupFieldMap);
        for (MdmPriceConditionTypeRelGroupEntity priorityGroup : priorityGroups) {
            String conditionGroupCode = priorityGroup.getConditionGroupCode();
            String conditionTypeCode = priorityGroup.getConditionTypeCode();
            if (!StringUtils.isEmpty(conditionGroupCode) && !StringUtils.isEmpty(conditionTypeCode)) {
                List<MdmPriceConditionGroupRelFieldRespVo> groupFields = groupFieldMap.get(conditionGroupCode);
                if (!CollectionUtils.isEmpty(groupFields)) {
                    List<String> fieldList = groupFields.stream()
                            .filter(x -> x != null && !StringUtils.isEmpty(x.getFieldCode()))
                            .map(MdmPriceConditionGroupRelFieldRespVo::getFieldCode)
                            .collect(Collectors.toList());
                    map.put(conditionTypeCode, fieldList);
                }
            }
        }
        return map;
    }

    @Override
    public Map<String, List<List<String>>> groupList(List<String> conditionTypeCodeList) {
        if (CollectionUtils.isEmpty(conditionTypeCodeList)) {
            return Collections.emptyMap();
        }

        List<MdmPriceConditionTypeRelGroupEntity> groupEntities = this.lambdaQuery()
                .in(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, conditionTypeCodeList)
                .list();
        log.info("根据字段类型编码集合查询所有条件分类:{}", groupEntities);
        if (CollectionUtils.isEmpty(groupEntities)) {
            return Collections.emptyMap();
        }

        List<String> conditionGroupCodeList = groupEntities.stream()
                .filter(x -> !StringUtils.isEmpty(x.getConditionGroupCode()))
                .map(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode)
                .collect(Collectors.toList());
        Map<String, List<String>> groupFieldMap
                = mdmPriceConditionGroupRelFieldService.getFieldByGroupCodeList(conditionGroupCodeList);
        if (ObjectUtils.isEmpty(groupFieldMap)) {
            return Collections.emptyMap();
        }
        log.info("根据条件字段分类编码集合查询分类字段分组:{}", groupFieldMap);

        return groupEntities.stream()
                .collect(Collectors.groupingBy(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode
                        , Collectors.collectingAndThen(Collectors.toList(), x -> x.stream()
                                .sorted(Comparator.comparing(k -> Optional.ofNullable(k.getSortNum()).orElse(1000)))
                                .map(k -> groupFieldMap.get(k.getConditionGroupCode()))
                                .collect(Collectors.toList()))));
    }
}

