package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeRelGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.*;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeEntity;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.*;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 条件字段类型主表 接口实现
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmPriceConditionTypeServiceExpandImpl")
public class MdmPriceConditionTypeServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmPriceConditionTypeMapper, MdmPriceConditionTypeEntity> implements MdmPriceConditionTypeService {

    @Resource
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;
    @Resource
    private MdmPriceConditionGroupService mdmPriceConditionGroupService;
    @Resource
    private MdmPriceConditionTypeRelGroupService mdmPriceConditionTypeRelGroupService;
    @Resource
    private IMdmPriceSettingService mdmPriceSettingService;
    @Resource
    private MdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmPriceConditionTypeRespVo> findList(MdmPriceConditionTypeReqVo reqVo) {
        Page<MdmPriceConditionTypeRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmPriceConditionTypeRespVo> list = mdmPriceConditionTypeMapper.findList(page, reqVo
                );
        return PageResult.<MdmPriceConditionTypeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmPriceConditionTypeRespVo> priceConditionTypeSelectList(MdmPriceConditionTypeReqVo reqVo) {
        List<MdmPriceConditionTypeEntity> list = this.lambdaQuery()
                .like(!StringUtils.isEmpty(reqVo.getConditionTypeDesc()), MdmPriceConditionTypeEntity::getConditionTypeCode, reqVo.getConditionTypeDesc())
                .or()
                .like(!StringUtils.isEmpty(reqVo.getConditionTypeDesc()), MdmPriceConditionTypeEntity::getConditionTypeDesc, reqVo.getConditionTypeDesc())
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return list.stream().map(item -> {
                MdmPriceConditionTypeRespVo copy = CrmBeanUtil.copy(item, MdmPriceConditionTypeRespVo.class);
                copy.setConditionTypeDesc(item.getConditionTypeCode() + "/" + item.getConditionTypeDesc());
                return copy;
            }).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public MdmPriceConditionTypeRespVo query(String id, String conditionTypeCode) {
        if (StringUtils.isNotEmpty(id) || StringUtils.isNotEmpty(conditionTypeCode)) {
            MdmPriceConditionTypeEntity one = this.lambdaQuery()
                    .eq(StringUtils.isNotEmpty(id), MdmPriceConditionTypeEntity::getId, id)
                    .eq(StringUtils.isNotEmpty(conditionTypeCode), MdmPriceConditionTypeEntity::getConditionTypeCode, conditionTypeCode)
                    .one();
            if (one != null) {
                MdmPriceConditionTypeRespVo respVo = CrmBeanUtil.copy(one, MdmPriceConditionTypeRespVo.class);
                List<MdmPriceConditionTypeRelGroupEntity> list = mdmPriceConditionTypeRelGroupService.lambdaQuery()
                        .eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, one.getConditionTypeCode())
                        .orderByAsc(MdmPriceConditionTypeRelGroupEntity::getSortNum)
                        .list();
                if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                    respVo.setConditionTypeRelGroupReqVoList(CrmBeanUtil.copyList(list, MdmPriceConditionTypeRelGroupRespVo.class));
                }
                return respVo;
            }
        }
        return null;
    }

    @Override
    public MdmPriceOperationCheckRespVo editCheck(String id) {
        MdmPriceOperationCheckRespVo respVo = new MdmPriceOperationCheckRespVo();
        respVo.setEditCheck(true);
        Assert.hasText(id, "空参数");
        MdmPriceConditionTypeEntity entity = this.getById(id);
        Assert.notNull(entity, "无效的id");
        List<MdmPriceSettingEntity> relSettingList = mdmPriceSettingService.lambdaQuery()
                .eq(MdmPriceSettingEntity::getConditionTypeCode, entity.getConditionTypeCode())
                .select(MdmPriceSettingEntity::getId)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(relSettingList)) {
            respVo.setEditCheck(false);
            respVo.setMessage("条件类型编码为" + entity.getConditionTypeCode() + "的数据已进行价格维护，不可编辑");
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmPriceConditionTypeReqVo reqVo) {
        Assert.hasText(reqVo.getConditionTypeDesc(), "缺失条件类型描述");
//        Assert.hasText(reqVo.getConditionTypeType(), "缺失抬头/行项目");
        if (StringUtils.isNotEmpty(reqVo.getConditionTypeCode())) {
            List<MdmPriceConditionTypeEntity> list = this.lambdaQuery()
                    .eq(MdmPriceConditionTypeEntity::getConditionTypeCode, reqVo.getConditionTypeCode())
                    .select(MdmPriceConditionTypeEntity::getId)
                    .list();
            Assert.isTrue(CollectionUtil.listEmpty(list), "条件类型编码已经存在");
        }
        Assert.notEmpty(reqVo.getConditionTypeRelGroupReqVoList(), "请选择条件类型分类");
        LinkedHashSet<String> conditionGroupCodeSet = new LinkedHashSet<>(16);
        int x = 0;
        final Map<String, String> groupMap = mdmPriceConditionGroupService.getGroupMap();
        for (int i = 0; i < reqVo.getConditionTypeRelGroupReqVoList().size(); i++) {
            MdmPriceConditionTypeRelGroupReqVo item = reqVo.getConditionTypeRelGroupReqVoList().get(i);
            Assert.hasText(item.getConditionGroupCode(), "第" + (i + 1) + "行缺失条件字段分类编码");
            Assert.isTrue(groupMap.containsKey(item.getConditionGroupCode()), "条件字段分类编码无效");
            item.setConditionGroupName(groupMap.get(item.getConditionGroupCode()));
            item.setSortNum((i + 1));
            if (conditionGroupCodeSet.contains(item.getConditionGroupCode())){
                Iterator l = conditionGroupCodeSet.iterator();
                while (l.hasNext()){
                    x+=1;
                    if (l.next().equals(item.getConditionGroupCode())){
                        break;
                    }
                }
            }
            int y = i+1;
            Assert.isTrue(!conditionGroupCodeSet.contains(item.getConditionGroupCode()), "条件分类"+x+"与"+"条件分类"+y+"重复");
            conditionGroupCodeSet.add(item.getConditionGroupCode());

        }
        MdmPriceConditionTypeEntity entity = CrmBeanUtil.copy(reqVo, MdmPriceConditionTypeEntity.class);
        if (StringUtils.isEmpty(entity.getConditionTypeCode())) {
            entity.setConditionTypeCode(CodeUtil.createOneCode(CrmCodeRuleConstants.PRICE_CONDITION_TYPE));
        }
        this.save(entity);
        reqVo.getConditionTypeRelGroupReqVoList().forEach(item -> {
            item.setConditionTypeCode(entity.getConditionTypeCode());
        });
        mdmPriceConditionTypeRelGroupService.saveBatch(CrmBeanUtil.copyList(reqVo.getConditionTypeRelGroupReqVoList(), MdmPriceConditionTypeRelGroupEntity.class));
        //添加日志
        MdmPriceConditionTypeRespVo newVo = CrmBeanUtil.copy(entity, MdmPriceConditionTypeRespVo.class);
        Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if(menuObject!=null){
            crmLogSendUtil.sendForAdd(menuObject.toString(),newVo.getId(),newVo.getId(),newVo);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmPriceConditionTypeReqVo reqVo) {
        Assert.hasText(reqVo.getId(), "缺失id");
        Assert.hasText(reqVo.getConditionTypeCode(), "缺失条件类型编码");
        Assert.hasText(reqVo.getConditionTypeDesc(), "缺失条件类型描述");
//        Assert.hasText(reqVo.getConditionTypeType(), "抬头/行项目");
        MdmPriceConditionTypeEntity entity = this.getById(reqVo.getId());
        MdmPriceConditionTypeRespVo oldVo = CrmBeanUtil.copy(entity, MdmPriceConditionTypeRespVo.class);
        Assert.notNull(entity, "无效的id");
        List<MdmPriceSettingEntity> relSettingList = mdmPriceSettingService.lambdaQuery()
                .eq(MdmPriceSettingEntity::getConditionTypeCode, entity.getConditionTypeCode())
                .select(MdmPriceSettingEntity::getId)
                .list();
        Assert.isTrue(CollectionUtil.listEmpty(relSettingList), "条件类型已经关联价格维护，不能修改");
        Assert.isTrue(entity.getConditionTypeCode().equals(reqVo.getConditionTypeCode()), "条件类型编码不能修改");
        Assert.notEmpty(reqVo.getConditionTypeRelGroupReqVoList(), "请选择条件类型分类");
        final Map<String, String> groupMap = mdmPriceConditionGroupService.getGroupMap();
        Set<String> conditionGroupCodeSet = new HashSet<>(16);
        for (int i = 0; i < reqVo.getConditionTypeRelGroupReqVoList().size(); i++) {
            MdmPriceConditionTypeRelGroupReqVo item = reqVo.getConditionTypeRelGroupReqVoList().get(i);
            Assert.hasText(item.getConditionGroupCode(), "第" + (i + 1) + "行缺失条件字段分类编码");
            Assert.isTrue(groupMap.containsKey(item.getConditionGroupCode()), "条件字段分类编码无效");
            item.setConditionGroupName(groupMap.get(item.getConditionGroupCode()));
            item.setSortNum((i + 1));
            Assert.isTrue(!conditionGroupCodeSet.contains(item.getConditionGroupCode()), "条件字段分类编码重复");
            conditionGroupCodeSet.add(item.getConditionGroupCode());
        }
        CrmBeanUtil.copyProperties(reqVo, entity);
        this.updateById(entity);
        mdmPriceConditionTypeRelGroupService.lambdaUpdate()
                .eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, entity.getConditionTypeCode())
                .remove();
        reqVo.getConditionTypeRelGroupReqVoList().forEach(item -> {
            item.setConditionTypeCode(entity.getConditionTypeCode());
        });
        mdmPriceConditionTypeRelGroupService.saveBatch(CrmBeanUtil.copyList(reqVo.getConditionTypeRelGroupReqVoList(), MdmPriceConditionTypeRelGroupEntity.class));
        //记录更新日志
        MdmPriceConditionTypeRespVo newVo = CrmBeanUtil.copy(entity, MdmPriceConditionTypeRespVo.class);
       Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
       if(menuObject!=null){
           crmLogSendUtil.sendForUpdate(menuObject.toString(),newVo.getId(),newVo.getId(),oldVo,newVo);
       }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, "请选择需要删除的数据");
        List<MdmPriceConditionTypeEntity> list = this.lambdaQuery()
                .in(MdmPriceConditionTypeEntity::getId, ids)
                .select(MdmPriceConditionTypeEntity::getId, MdmPriceConditionTypeEntity::getConditionTypeCode)
                .list();
        AssertUtils.isNotEmpty(list, "无效的参数");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                List<MdmPriceSettingEntity> priceSettingList = mdmPriceSettingService.lambdaQuery()
                        .eq(MdmPriceSettingEntity::getConditionTypeCode, item.getConditionTypeCode())
                        .select(MdmPriceSettingEntity::getId)
                        .list();
                Assert.isTrue(CollectionUtil.listEmpty(priceSettingList), "条件类型编码为[" + item.getConditionTypeCode() + "]的数据已进行价格维护，不可删除");

                mdmPriceConditionTypeRelGroupService.lambdaUpdate()
                        .eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, item.getConditionTypeCode())
                        .remove();
            });
            this.removeByIds(ids);
        }
    }

    @Override
    public List<MdmPriceConditionTypeRelGroupRespVo> groupByConditionType(MdmPriceConditionTypeReqVo reqVo) {
        Assert.hasText(reqVo.getConditionTypeCode(), "条件类型编码不能为空");
        List<MdmPriceConditionTypeRelGroupEntity> list = mdmPriceConditionTypeRelGroupService.lambdaQuery()
                .eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, reqVo.getConditionTypeCode())
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> collect = list.stream().map(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode).collect(Collectors.toList());
            final Map<String, List<MdmPriceConditionGroupRelFieldRespVo>> map = mdmPriceConditionGroupRelFieldService.getRelFieldGroupByGroupCodeList(collect);
            final Map<String, String> groupCodeNameMap = mdmPriceConditionGroupService.getGroupMap(collect);
            return list.stream().map(item -> {
                MdmPriceConditionTypeRelGroupRespVo respVo = CrmBeanUtil.copy(item, MdmPriceConditionTypeRelGroupRespVo.class);
                respVo.setConditionGroupName(groupCodeNameMap.get(item.getConditionGroupCode()));
                respVo.setMdmPriceConditionGroupRelFieldRespVos(map.get(item.getConditionGroupCode()));
                return respVo;
            }).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }
}
