package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.eunm.mdm.PriceSettingStatusEnum;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeEntity;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 价格维护接口工具类
 *
 * @author zeyi
 */
@Slf4j
@Service
public class MdmPriceSettingServiceHelper {

    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;

    @Autowired
    private IMdmPriceSettingService iMdmPriceSettingService;

    @Autowired
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;

    @Autowired
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;

    @Resource
    private MdmProductService mdmProductService;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 新增,编辑,校验
     *
     * @param reqVo
     */
    public void saveCheck(MdmPriceSettingReqVo reqVo) {
        //数据必填校验
        this.dataRequired(reqVo);
        //设置生效状态
//        this.setUpEnableStatus(reqVo);
    }

    /**
     * 数据非法校验
     *
     * @param reqVo
     */
    private List<MdmPriceConditionGroupRelFieldEntity> dataIllegal(MdmPriceSettingReqVo reqVo) {
        //验证字段是否存在
        List<MdmPriceConditionTypeEntity> conditionTypeEntities = mdmPriceConditionTypeMapper
                .selectList(Wrappers.<MdmPriceConditionTypeEntity>lambdaQuery()
                        .eq(MdmPriceConditionTypeEntity::getConditionTypeCode, reqVo.getConditionTypeCode()));
        AssertUtils.isNotEmpty(conditionTypeEntities, "条件类型编码不存在");
        List<MdmPriceConditionGroupRelFieldEntity> fieldEntities = mdmPriceConditionGroupRelFieldMapper
                .selectList(Wrappers.<MdmPriceConditionGroupRelFieldEntity>lambdaQuery()
                        .eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, reqVo.getConditionGroupCode()));
        AssertUtils.isNotEmpty(fieldEntities, "条件字段分类编码不存在");
        return fieldEntities;
    }


    /**
     * 保存或修改数据
     *
     * @param reqVo
     */
    public void dataUniqueSaveOrUpdate(MdmPriceSettingReqVo reqVo) {
        boolean b = false;
        MdmPriceSettingEntity old = null;
        if(StringUtils.isNotEmpty(reqVo.getId())){
            b = true;
            old = iMdmPriceSettingService.getById(reqVo.getId());
        }
        if (!YesNoEnum.yesNoEnum.Y.getValue().equalsIgnoreCase(ParamUtil.getParameterValueNoException(ParameterParam.PRICE_CHUNK_CONFIG))) {
            MdmPriceSettingEntity mdmPriceSettingReq = CrmBeanUtil.copy(reqVo, MdmPriceSettingEntity.class);
            mdmPriceSettingReq.setPriceSettingCode(CodeUtil.createOneCode(CrmCodeRuleConstants.MDM_PRICE_SETTING));
            String productCode = mdmPriceSettingReq.getProductCode();
            if(!StringUtils.isEmpty(productCode)){
                MdmProductRespVo detail = mdmProductService.detail(null, productCode);
                if (detail != null) {
                    mdmPriceSettingReq.setProductName(detail.getProductName());
                }
            }
            iMdmPriceSettingService.saveOrUpdate(mdmPriceSettingReq);
            Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            if (menuObject != null) {
                if(b){
                    crmLogSendUtil.sendForUpdate((String) menuObject, mdmPriceSettingReq.getId(),null,CrmBeanUtil.copy(old, MdmPriceSettingReqVo.class),reqVo);
                } else {
                    crmLogSendUtil.sendForAdd((String) menuObject, mdmPriceSettingReq.getId(), null, reqVo);
                }
            }
            return;
        }
        QueryWrapper<MdmPriceSettingEntity> wrapper = wrapperCondition(reqVo);
        List<MdmPriceSettingEntity> list = mdmPriceSettingMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<MdmPriceSettingReqVo> mdmPriceSettingReqVos = CrmBeanUtil.copyList(list, MdmPriceSettingReqVo.class);
            List<MdmPriceSettingReqVo> oldList = new ArrayList<>(mdmPriceSettingReqVos);
            List<MdmPriceSettingReqVo> mdmPriceSettingReqVoList = this.timeTruncation(reqVo, mdmPriceSettingReqVos);
            Map<String,MdmPriceSettingReqVo> newMap = new HashMap<>();
            if (CollectionUtil.listNotEmpty(mdmPriceSettingReqVoList)) {
                mdmPriceSettingReqVoList.forEach(mdmPriceSettingReqVo -> {
                    Date beginDate = DateUtil.localDateTimeConvertToDate(mdmPriceSettingReqVo.getBeginDateTime());
                    Date endDate = DateUtil.localDateTimeConvertToDate(mdmPriceSettingReqVo.getEndDateTime());
                    mdmPriceSettingReqVo.setBeginDate(DateUtil.getFormatDateStr(beginDate, DateUtil.DEFAULT_DAY_PATTERN));
                    mdmPriceSettingReqVo.setBeginDateSecond(DateUtil.getFormatDateStr(beginDate, DateUtil.DEFAULT_TIME_ALL_PATTERN));
                    mdmPriceSettingReqVo.setEndDate(DateUtil.getFormatDateStr(endDate, DateUtil.DEFAULT_DAY_PATTERN));
                    mdmPriceSettingReqVo.setEndDateSecond(DateUtil.getFormatDateStr(endDate, DateUtil.DEFAULT_TIME_ALL_PATTERN));
                    newMap.put(mdmPriceSettingReqVo.getId(),mdmPriceSettingReqVo);
                });
                iMdmPriceSettingService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmPriceSettingReqVoList, MdmPriceSettingEntity.class));
                Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
                if (menuObject != null) {
                    oldList.forEach(i->{
                        if(newMap.containsKey(i.getId())){
                            crmLogSendUtil.sendForUpdate((String) menuObject, i.getId(),null,i,newMap.get(i.getId()));
                        }
                    });
                }
            }
        } else {
            MdmPriceSettingEntity mdmPriceSettingReq = CrmBeanUtil.copy(reqVo, MdmPriceSettingEntity.class);
            mdmPriceSettingReq.setPriceSettingCode(CodeUtil.createOneCode(CrmCodeRuleConstants.MDM_PRICE_SETTING));
            iMdmPriceSettingService.saveOrUpdate(mdmPriceSettingReq);
            Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            if (menuObject != null) {
                if(b){
                    crmLogSendUtil.sendForUpdate((String) menuObject, mdmPriceSettingReq.getId(),null,CrmBeanUtil.copy(old, MdmPriceSettingReqVo.class),reqVo);
                } else {
                    crmLogSendUtil.sendForAdd((String) menuObject, mdmPriceSettingReq.getId(), null, reqVo);
                }
            }
        }
    }

    protected QueryWrapper<MdmPriceSettingEntity> wrapperCondition(MdmPriceSettingReqVo reqVo) {
        if (StringUtils.isNotEmpty(reqVo.getProductCode())) {
            MdmProductEntity product = mdmProductService.lambdaQuery()
                    .eq(MdmProductEntity::getProductCode, reqVo.getProductCode())
                    .select(MdmProductEntity::getProductName)
                    .one();
            if (product != null) {
                reqVo.setProductName(product.getProductName());
            }
        }
        //设置wrapper
        QueryWrapper<MdmPriceSettingEntity> wrapper = setUpWrapper(reqVo);
        //设置字段条件并验证
        setFieldCondition(wrapper, reqVo);
        return wrapper;
    }

    protected QueryWrapper<MdmPriceSettingEntity> setUpWrapper(MdmPriceSettingReqVo reqVo) {
        QueryWrapper<MdmPriceSettingEntity> wrapper = new QueryWrapper<>();
        Map<String, String> map = DictUtil.dictMap(DictConstant.PRICE_TRUNCATION);
        if (map.containsKey("condition_type_code") && !StringUtils.isEmpty(reqVo.getConditionTypeCode())) {
            wrapper.eq("condition_type_code", reqVo.getConditionTypeCode());
        }
        if (map.containsKey("condition_group_code")&&!StringUtils.isEmpty(reqVo.getConditionGroupCode())) {
            wrapper.eq("condition_group_code", reqVo.getConditionGroupCode());
        }
        if (map.containsKey("currency_type")&&!StringUtils.isEmpty(reqVo.getCurrencyType())) {
            wrapper.eq("currency_type", reqVo.getCurrencyType());
        }
        if (map.containsKey("price_unit")&&!StringUtils.isEmpty(reqVo.getPriceUnit())) {
            wrapper.eq("price_unit", reqVo.getPriceUnit());
        }
        if (map.containsKey("unit_type")&&!StringUtils.isEmpty(reqVo.getUnitType())) {
            wrapper.eq("unit_type", reqVo.getUnitType());
        }
        if(map.containsKey("ext1")&&!StringUtils.isEmpty(reqVo.getExt1())){
            wrapper.eq("ext1", reqVo.getExt1());
        }
        if(map.containsKey("ext2")&&!StringUtils.isEmpty(reqVo.getExt2())){
            wrapper.eq("ext2", reqVo.getExt2());
        }
        if(map.containsKey("ext3")&&!StringUtils.isEmpty(reqVo.getExt3())){
            wrapper.eq("ext3", reqVo.getExt3());
        }
        if(map.containsKey("ext4")&&!StringUtils.isEmpty(reqVo.getExt4())){
            wrapper.eq("ext4", reqVo.getExt4());
        }
        if(map.containsKey("ext5")&&!StringUtils.isEmpty(reqVo.getExt5())){
            wrapper.eq("ext5", reqVo.getExt5());
        }
        if(map.containsKey("ext6")&&!StringUtils.isEmpty(reqVo.getExt6())){
            wrapper.eq("ext6", reqVo.getExt6());
        }
        if(map.containsKey("ext7")&&!StringUtils.isEmpty(reqVo.getExt7())){
            wrapper.eq("ext7", reqVo.getExt7());
        }
        if(map.containsKey("ext8")&&!StringUtils.isEmpty(reqVo.getExt8())){
            wrapper.eq("ext8", reqVo.getExt8());
        }
        if(map.containsKey("ext9")&&!StringUtils.isEmpty(reqVo.getExt9())){
            wrapper.eq("ext9", reqVo.getExt9());
        }
        if(map.containsKey("ext10")&&!StringUtils.isEmpty(reqVo.getExt10())){
            wrapper.eq("ext10", reqVo.getExt10());
        }
        return wrapper;
    }

    /**
     * 设置字段条件并验证
     *
     * @param wrapper
     * @param reqVo
     */
    public void setFieldCondition(QueryWrapper<MdmPriceSettingEntity> wrapper, MdmPriceSettingReqVo reqVo) {
        //设置字段条件并验证
        List<MdmPriceConditionGroupRelFieldEntity> fieldEntities = this.dataIllegal(reqVo);
        fieldEntities.forEach(fieldEntity -> {
            if (PriceSettingFieldEnum.CHANNEL.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getChannel(), "渠道不能为空");
                wrapper.eq("channel", reqVo.getChannel());
            }
            if (PriceSettingFieldEnum.CUSTOMER_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getCustomerCode(), "客户不能为空");
                wrapper.eq("customer_code", reqVo.getCustomerCode());
            }
            if (PriceSettingFieldEnum.ORG_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getOrgCode(), "组织不能为空");
                wrapper.eq("org_code", reqVo.getOrgCode());
            }
            if (PriceSettingFieldEnum.PRODUCT_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getProductCode(), "产品不能为空");
                wrapper.eq("product_code", reqVo.getProductCode());
            }
            if (PriceSettingFieldEnum.TERMINAL.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端不能为空");
                wrapper.eq("terminal_code", reqVo.getTerminalCode());
            }
            if (PriceSettingFieldEnum.PRICE_GROUP.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty(reqVo.getPriceGroup(), "价格组不能为空");
                wrapper.eq("price_group", reqVo.getPriceGroup());
            }
        });
    }


    /**
     * 获取新增的时间价格数据
     * MdmPriceSettingRespVo DB历史数据   MdmPriceSettingReqVo新增数据
     *
     * @param reqVo
     * @param list
     */
    private List<MdmPriceSettingReqVo> timeTruncation(MdmPriceSettingReqVo reqVo,
                                                      List<MdmPriceSettingReqVo> list) {
        reqVo.setBeginDateTime(DateUtil.dateConvertToLocalDateTime(DateUtil.str2Date(reqVo.getBeginDate().trim().concat(" ").concat(reqVo.getBeginDateSecond()),
                DateUtil.datetimeFormat)));
        reqVo.setEndDateTime(DateUtil.dateConvertToLocalDateTime(DateUtil.str2Date(reqVo.getEndDate().trim().concat(" ").concat(reqVo.getEndDateSecond()),
                DateUtil.datetimeFormat)));
        reqVo.setPriceSettingCode(CodeUtil.createOneCode(CrmCodeRuleConstants.MDM_PRICE_SETTING));
        List<MdmPriceSettingReqVo> priceSettingReqVos = new ArrayList<>();
        for (MdmPriceSettingReqVo priceSetting : list) {
            priceSetting.setBeginDateTime(DateUtil.dateConvertToLocalDateTime(DateUtil.str2Date(priceSetting.getBeginDate().trim().concat(" ").concat(priceSetting.getBeginDateSecond()),
                    DateUtil.datetimeFormat)));
            priceSetting.setEndDateTime(DateUtil.dateConvertToLocalDateTime(DateUtil.str2Date(priceSetting.getEndDate().trim().concat(" ").concat(priceSetting.getEndDateSecond()),
                    DateUtil.datetimeFormat)));
            priceSettingReqVos.addAll(this.generate(priceSetting, reqVo));
        }
        List<MdmPriceSettingReqVo> collect = priceSettingReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(()
                -> new TreeSet<>(Comparator.comparing(MdmPriceSettingReqVo::getPriceSettingCode))), ArrayList::new));
        return collect;
    }

    /**
     * 时间截取
     *
     * @param data1 DB中存在的时间
     * @param data2 当前新增的时间
     * @return
     */
    private List<MdmPriceSettingReqVo> generate(MdmPriceSettingReqVo data1, MdmPriceSettingReqVo data2) {
        List<MdmPriceSettingReqVo> list = Stream.of(data1, data2).collect(Collectors.toList());
        long s1 = data1.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long e1 = data1.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long s2 = data2.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long e2 = data2.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        //新增开始时间>db开始时间
        if (s2 <= s1) {
            //新增结束时间>db开始时间
            if (e2 >= s1) {
                //新增结束时间<db结束时间
                if (e2 < e1) {
                    data1.setBeginDateTime(data2.getEndDateTime().plusSeconds(1));
                } else {
                    list.remove(data1);
                    mdmPriceSettingMapper.deleteById(data1.getId());
                }
            }
        } else if (s2 <= e1) {
            //新增开始时间>db开始时间&&新增开始时间<db结束时间
            if (e2 < e1) {
                //新增结束时间>db结束时间,整体后移截断
                LocalDateTime endDate = data1.getEndDateTime();
                data1.setEndDateTime(data2.getBeginDateTime().plusSeconds(-1));
                MdmPriceSettingReqVo data3 = CrmBeanUtil.copy(data1, MdmPriceSettingReqVo.class);
                data3.setBeginDateTime(data2.getEndDateTime().plusSeconds(1));
                data3.setEndDateTime(endDate);
                data3.setPrice(data1.getPrice());
                data3.setId("");
                data3.setPriceSettingCode(CodeUtil.createOneCode(CrmCodeRuleConstants.MDM_PRICE_SETTING));
                list.add(data3);
            } else {
                //新增结束时间<db结束时间,被覆盖
                data1.setEndDateTime(data2.getBeginDateTime().plusSeconds(-1));
            }
        }
        return list;
    }

    /**
     * 数据必填校验
     *
     * @param reqVo
     */
    private void dataRequired(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getConditionTypeCode(), "条件类型编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getConditionGroupCode(), "条件字段分类编码不能为空");
        AssertUtils.isNotNull(reqVo.getPrice(), "价格不能为空");
        AssertUtils.isNotNull(reqVo.getCurrencyType(), "币种编码不能为空");
//        AssertUtils.isNotNull(reqVo.getPriceUnit(), "价格单位不能为空");
        AssertUtils.isNotNull(reqVo.getBeginDate(), "有效期开始日期不能为空");
        AssertUtils.isNotNull(reqVo.getEndDate(), "有效期结束日期不能为空");
        if (StringUtils.isEmpty(reqVo.getBeginDateSecond())) {
            reqVo.setBeginDateSecond(DateUtil.DAY_EARLIEST_TIME);
        }
        if (StringUtils.isEmpty(reqVo.getEndDateSecond())) {
            reqVo.setEndDateSecond(DateUtil.DAY_LATEST_TIME);
        }
        long dateStart = DateUtil.str2Date(reqVo.getBeginDate().trim().concat(" ").concat(reqVo.getBeginDateSecond()), DateUtil.datetimeFormat).getTime();
        long dateEnd = DateUtil.str2Date(reqVo.getEndDate().trim().concat(" ").concat(reqVo.getEndDateSecond()), DateUtil.datetimeFormat).getTime();
        AssertUtils.isTrue(dateStart < dateEnd, "开始日期不能大于或者等于结束日期");
    }

    /**
     * 设置有效状态
     *
     * @param reqVo
     */
    public void setUpEnableStatus(MdmPriceSettingReqVo reqVo) {
        String staterStr = reqVo.getBeginDate().trim().concat(" ").concat(reqVo.getBeginDateSecond());
        String endStr = reqVo.getEndDate().trim().concat(" ").concat(reqVo.getEndDateSecond());
        Date staterData = DateUtil.str2Date(staterStr, DateUtil.datetimeFormat);
        Date endData = DateUtil.str2Date(endStr, DateUtil.datetimeFormat);
        Date date = DateUtil.getDate();
        if (DateUtil.equalIsDateMoreThanAnother(staterData, date)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.TO_BE_EFFECTIVE.getCode());
        }
        if (DateUtil.equalIsDateMoreThanAnother(date, staterData) && DateUtil.equalIsDateMoreThanAnother(endData, date)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.IN_EFFECT.getCode());
        }
        if (DateUtil.equalIsDateMoreThanAnother(date, endData)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.EXPIRED.getCode());
        }
    }

    public Boolean checkTimeTruncation(MdmPriceSettingReqVo reqVo) {
        Assert.hasText(reqVo.getBeginDate(), "开始时间不能为空");
        Assert.hasText(reqVo.getEndDate(), "结束时间不能为空");
        BigDecimal price = reqVo.getPrice();
        Assert.notNull(price, "价格不能为空");
        QueryWrapper<MdmPriceSettingEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("condition_type_code", reqVo.getConditionTypeCode());
        wrapper.eq("condition_group_code", reqVo.getConditionGroupCode());
        if (!StringUtils.isEmpty(reqVo.getCurrencyType())) {
            wrapper.eq("currency_type", reqVo.getCurrencyType());
        }
        if (!StringUtils.isEmpty(reqVo.getPriceUnit())) {
            wrapper.eq("price_unit", reqVo.getPriceUnit());
        }
        if(!StringUtils.isEmpty(reqVo.getUnitType())){
            wrapper.eq("unit_type", reqVo.getUnitType());
        }

        //设置字段条件并验证
        setFieldCondition(wrapper, reqVo);
        List<MdmPriceSettingEntity> list = mdmPriceSettingMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        return list.stream().allMatch(x -> {
            String beginDate = x.getBeginDate();
            String endDate = x.getEndDate();
            if (StringUtils.isEmpty(beginDate) || StringUtils.isEmpty(endDate)) {
                return true;
            }
            return endDate.compareTo(reqVo.getBeginDate()) < 0 || beginDate.compareTo(reqVo.getEndDate()) > 0;
        });
    }
}
