package com.biz.crm.product.event.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.nebular.mdm.product.req.ProductChangeHandlerReqVo;
import com.biz.crm.product.event.ProductChangeEvent;
import com.biz.crm.product.handler.ProductChangeHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

import java.util.List;

/**
 * @author sunx
 * @date 2021/9/13
 */
@Component
@Slf4j
public class ProductEventListener {
    /**
     * 商品信息变更实现
     */
    @Autowired(required = false)
    private List<ProductChangeHandler> productChangeHandlers;

    @Async
    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT)
    public void onProductChangeEvent(ProductChangeEvent event) {
        ProductChangeHandlerReqVo vo = (ProductChangeHandlerReqVo) event.getSource();
        log.info("商品信息改变事件监听:{}", JSON.toJSONString(vo));
        if (CollectionUtils.isNotEmpty(productChangeHandlers)) {
            productChangeHandlers.forEach(a -> a.handler(vo));
        }
        log.info("商品信息改变事件监听处理完成");
    }
}
