package com.biz.crm.product.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.product.req.MdmProductAndProductLevelReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductSelectReqVo;
import com.biz.crm.nebular.mdm.product.resp.*;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.provider.MdmProductProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 商品主表
 * 
 * @author crm
 * @date 2020-08-27 17:34:16
 */
public interface MdmProductMapper extends BaseMapper<MdmProductEntity> {
    /**
     * 列表
     * @param page
     * @param page
     * @return
     */
    List<MdmProductRespVo> findList(Page<MdmProductRespVo> page, @Param("vo") MdmProductReqVo vo);

    /**
     * 列表
     * @param page
     * @param page
     * @return
     */
    @SelectProvider(type = MdmProductProvider.class,method = "findListProvider")
    List<MdmProductRespVo> findListProvider(Page<MdmProductRespVo> page, @Param("vo") MdmProductReqVo vo);



    /**
     * 根据商品编码集合查询物料销售公司
     * @param productCodeList 商品编码集合
     * @return list
     */
    List<MdmProductSaleCompanyRespVo> findSaleCompanyByProductCodeList(@Param("vo") List<String> productCodeList);

    /**
     * 查询产品和产品层级集合的集合
     *
     * @param reqVo
     * @return list
     */
    List<MdmProductAndProductLevelRespVo> findProductAndProductLevelByCodeOrName(Page<MdmProductAndProductLevelRespVo> page, @Param("vo") MdmProductAndProductLevelReqVo reqVo);

    /**
     * 商品下拉框
     *
     * @param reqVo
     * @param includeList 只查询这些编码
     * @param excludeList 排除这些编码
     * @return
     */
    List<MdmProductSelectRespVo> productSelectList(Page<MdmProductSelectRespVo> page, @Param("vo") MdmProductSelectReqVo reqVo, @Param("includeList") List<String> includeList, @Param("excludeList") List<String> excludeList);

    List<MdmProductBySfaRespVo> findProductListSourceSfa(Page<MdmProductBySfaRespVo> page, @Param("vo") MdmProductBySfaReqVo vo);

    /**
     * sfa tpm活动查询商品基础信息
     * @param productCodeList
     * @return
     */
    List<MdmProductBaseDataRespVo> findProductBaseSourceSfaTpmAct(@Param("productCodeList") List<String> productCodeList,@Param("now")String now);

    /**
     *
     * @param page
     * @param vo  MdmProductReqVo
     * @return
     */
    List<MdmProductRespVo> pageListWithCondition(Page<MdmProductRespVo> page, @Param("vo") MdmProductReqVo vo);
}
