package com.biz.crm.product.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.product.model.MdmProductMediaEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 
 * 
 * @author crm
 * @date 2020-08-27 17:34:16
 */
public interface MdmProductMediaMapper extends BaseMapper<MdmProductMediaEntity> {
    /**
     * 列表
     * @param page
     * @param params
     * @return
     */
    List<MdmProductMediaRespVo> findList(Page<MdmProductMediaRespVo> page, @Param("vo") MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 如果ids不为空,先将除ids之外的图片,视频删除
     * @param ids
     * @param productCode
     */
    void deleteNoNeedMedias(@Param("ids") List<String> ids, @Param("productCode") String productCode);
}
