package com.biz.crm.product.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-06 15:49
 **/
public class MdmProductProvider {

    public String findListProvider(Map<String,Object> map){
        MdmProductReqVo vo = (MdmProductReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("a.*, b.product_level_name");
            FROM("mdm_product a");
            LEFT_OUTER_JOIN("mdm_product_level b on a.product_level_code=b.product_level_code");
            if(StringUtils.isNotEmpty(vo.getProductType())){
                WHERE("a.product_type = #{vo.productType}");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status = #{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getSaleUnit())){
              WHERE("a.sale_unit = #{vo.saleUnit}");
            }
            if(StringUtils.isNotEmpty(vo.getBaseUnit())){
                WHERE("a.base_unit = #{vo.baseUnit}");
            }
            if(StringUtils.isNotEmpty(vo.getIsShelf())){
                WHERE("a.is_shelf = #{vo.isShelf}");
            }
            if(StringUtils.isNotEmpty(vo.getBarCode())){
                WHERE("a.bar_code like "+ProviderUtil.bindPercent(vo.getBarCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getProductCode())){
                WHERE("a.product_code like "+ProviderUtil.bindPercent(vo.getProductCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getProductName())){
                WHERE("a.product_name like "+ProviderUtil.bindPercent(vo.getProductName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRuleCode())){
                WHERE("b.rule_code like "+ProviderUtil.bindPercent(vo.getRuleCode(),MdmProviderEnum.SQL_JOIN_RIGHT));
            }
            if(StringUtils.isNotEmpty(vo.getProductLevelName())){
                WHERE("b.product_level_name like "+ProviderUtil.bindPercent(vo.getProductLevelName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY(" a.create_date desc, a.create_date_second desc");
        }}.toString();


    }
}
