package com.biz.crm.product.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.product.req.MdmProductIntroductionReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.product.model.MdmProductIntroductionEntity;

/**
 * 接口
 *
 * @author huang.long
 * @date 2020-09-01 15:18:14
 */
public interface IMdmProductIntroductionService extends IService<MdmProductIntroductionEntity> {

    /**
     * 列表
     * @param mdmProductIntroductionReqVo
     * @return PageResult<MdmProductIntroductionRespVo>
     */
    PageResult<MdmProductIntroductionRespVo> findList(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 查询
     * @param mdmProductIntroductionReqVo
     * @return MdmProductIntroductionRespVo
     */
    MdmProductIntroductionRespVo query(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 新增
     * @param mdmProductIntroductionReqVo
     * @return
     */
    void save(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 更新
     * @param mdmProductIntroductionReqVo
     * @return
     */
    void update(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 删除
     * @param mdmProductIntroductionReqVo
     * @return
     */
    void deleteBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 启用
     * @param mdmProductIntroductionReqVo
     * @return
     */
    void enableBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);

    /**
     * 禁用
     * @param mdmProductIntroductionReqVo
     * @return
     */
    void disableBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo);
}

