package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.product.mapper.MdmProductMaterialMapper;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 接口实现
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmProductMaterialServiceExpandImpl")
public class MdmProductMaterialServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmProductMaterialMapper, MdmProductMaterialEntity> implements MdmProductMaterialService {

    @Resource
    private MdmProductMaterialMapper mdmProductMaterialMapper;

    @Resource
    private MdmMaterialService mdmMaterialService;

    /**
     * 列表
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    public PageResult<MdmProductMaterialRespVo> findList(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        Page<MdmProductMaterialRespVo> page = PageUtil.buildPage(mdmProductMaterialReqVo.getPageNum(), mdmProductMaterialReqVo.getPageSize());
        List<MdmProductMaterialRespVo> list = mdmProductMaterialMapper.findList(page, mdmProductMaterialReqVo);
        return PageResult.<MdmProductMaterialRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmProductMaterialRespVo> findProductMaterialList(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        if (StringUtils.isEmpty(mdmProductMaterialReqVo.getProductCode())) {
            return new ArrayList<>();
        }
        return mdmProductMaterialMapper.findList(null, mdmProductMaterialReqVo);
    }

    /**
     * 查询
     * @param mdmProductMaterialReqVo
     * @return mdmProductMaterialRespVo
     */
    @Override
    public MdmProductMaterialRespVo query(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        MdmProductMaterialRespVo respVo = null;
        if (StringUtils.isNotEmpty(mdmProductMaterialReqVo.getId()) || StringUtils.isNotEmpty(mdmProductMaterialReqVo.getMaterialCode())) {
            MdmProductMaterialEntity one = this.lambdaQuery()
                    .eq(StringUtils.isNotEmpty(mdmProductMaterialReqVo.getId()), MdmProductMaterialEntity::getId, mdmProductMaterialReqVo.getId())
                    .eq(StringUtils.isNotEmpty(mdmProductMaterialReqVo.getMaterialCode()), MdmProductMaterialEntity::getMaterialCode, mdmProductMaterialReqVo.getMaterialCode())
                    .one();
            if (one != null) {
                respVo = CrmBeanUtil.copy(one, MdmProductMaterialRespVo.class);
                MdmMaterialEntity material = mdmMaterialService.lambdaQuery()
                        .eq(MdmMaterialEntity::getMaterialCode, one.getMaterialCode())
                        .one();
                if (material != null) {
                    CrmBeanUtil.copyProperties(material,respVo);
                }
            }
        }
        return respVo;
    }

    /**
     * 新增
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        MdmProductMaterialEntity entity = CrmBeanUtil.copy(mdmProductMaterialReqVo,MdmProductMaterialEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        MdmProductMaterialEntity entity = this.getById(mdmProductMaterialReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        List<MdmProductMaterialEntity> mdmProductMaterialEntities = mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMaterialEntities)){
            mdmProductMaterialEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    /**
     * 启用
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        //设置状态为启用
        List<MdmProductMaterialEntity> mdmProductMaterialEntities = mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMaterialEntities)){
            mdmProductMaterialEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    /**
     * 禁用
     * @param mdmProductMaterialReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo){
        //设置状态为禁用
        List<MdmProductMaterialEntity> mdmProductMaterialEntities = mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMaterialEntities)){
                mdmProductMaterialEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }
}
