package com.biz.crm.productlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 产品层级
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Slf4j
@RestController
@RequestMapping("/mdmProductLevelController")
@Api(tags = "MDM-产品层级")
@CrmGlobalLog
public class MdmProductLevelController {

    @Autowired
    private MdmProductLevelService mdmProductLevelService;

    @ApiOperation(value = "查询列表(分页)")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> pageList(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        PageResult<MdmProductLevelRespVo> result = mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "产品层级公用分页弹框")
    @PostMapping("/commonPageList")
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> commonPageList(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        mdmProductLevelReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<MdmProductLevelRespVo> result = mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "productLevelCode", value = "产品层级编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmDictMethod
    public Result<MdmProductLevelRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "productLevelCode", required = false) String productLevelCode) {
        return Result.ok(mdmProductLevelService.detail(id, productLevelCode));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        mdmProductLevelService.save(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        mdmProductLevelService.update(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmProductLevelService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmProductLevelService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmProductLevelService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation("重置降维编码")
    @PostMapping("/resetRuleCode")
    public Result resetRuleCode() {
        mdmProductLevelService.resetRuleCode();
        ProductLevelUtil.reloadAllCache();
        return Result.ok();
    }

    @ApiOperation(value = "根据产品层级编码查询该产品层级及全部下级层级的编码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "productLevelCode", value = "产品层级编码", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/getAllChildrenProductLevelCodeList")
    public Result<List<String>> getAllChildrenProductLevelCodeList(@RequestParam("productLevelCode") String productLevelCode) {
        return Result.ok(mdmProductLevelService.getAllChildrenProductLevelCodeList(null, productLevelCode));
    }

    @ApiOperation(value = "产品层级下拉框(限制数量)")
    @PostMapping("/productLevelSelectList")
    @CrmDictMethod
    public Result<List<MdmProductLevelSelectRespVo>> productLevelSelectList(@RequestBody MdmProductLevelSelectReqVo reqVo) {
        return Result.ok(mdmProductLevelService.productLevelSelectList(reqVo));
    }

    @ApiOperation(value = "获取所有的产品层级")
    @GetMapping("/getAllProductLevelList")
    public Result<List<MdmProductLevelRespVo>> getAllProductLevelList() {
        return Result.ok(mdmProductLevelService.getAllProductLevelList());
    }

}
