package com.biz.crm.productlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelReloadRedisVo;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 产品层级表redis缓存数据查询请求接口类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmProductLevelRedisController")
@CrmGlobalLog
public class MdmProductLevelRedisController {

    @Autowired
    private MdmProductLevelService mdmProductLevelService;

    /**
     * 根据产品层级编码集合获取产品层级详情redis缓存数据
     *
     * @param productLevelCodeList 产品层级编码集合
     * @return
     */
    @PostMapping("/findRedisListByProductLevelCodeList")
    public Result<List<MdmProductLevelRedisVo>> findRedisListByProductLevelCodeList(@RequestBody List<String> productLevelCodeList) {
        return Result.ok(mdmProductLevelService.findRedisListByProductLevelCodeList(productLevelCodeList));
    }

    /**
     * 根据产品层级编码集合获取产品层级上级redis缓存数据
     *
     * @param productLevelCodeList 产品层级编码集合
     * @return
     */
    @PostMapping("/findRedisProductLevelParentListByCodeList")
    public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelParentListByCodeList(@RequestBody List<String> productLevelCodeList) {
        return Result.ok(mdmProductLevelService.findRedisProductLevelParentListByCodeList(productLevelCodeList));
    }

    /**
     * 根据产品层级编码集合获取产品层级下级redis缓存数据
     *
     * @param productLevelCodeList 产品层级编码集合
     * @return
     */
    @PostMapping("/findRedisProductLevelChildrenListByCodeList")
    public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelChildrenListByCodeList(@RequestBody List<String> productLevelCodeList) {
        return Result.ok(mdmProductLevelService.findRedisProductLevelChildrenListByCodeList(productLevelCodeList));
    }

    /**
     * 获取全部产品层级redis缓存数据
     *
     * @return
     */
    @PostMapping("/findRedisReloadList")
    public Result<List<MdmProductLevelReloadRedisVo>> findRedisReloadList() {
        return Result.ok(mdmProductLevelService.findRedisReloadList());
    }

}
