package com.biz.crm.productlevel.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.provider.MdmProductLevelProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
public interface MdmProductLevelMapper extends BaseMapper<MdmProductLevelEntity> {

    /**
     * 列表查询
     *
     * @param vo
     * @return
     */
    List<MdmProductLevelRespVo> findList(Page<MdmProductLevelRespVo> page, @Param("vo") MdmProductLevelReqVo vo, @Param("productLevelTypeSortList") List<String> productLevelTypeSortList);


    /**
     * 列表查询（provider）
     *
     * @param vo
     * @return
     */
    @SelectProvider(type = MdmProductLevelProvider.class,method = "findListProvider")
    List<MdmProductLevelRespVo> findListProvider(Page<MdmProductLevelRespVo> page, @Param("vo") MdmProductLevelReqVo vo, @Param("productLevelTypeSortList") List<String> productLevelTypeSortList);



    /**
     * 根据降维编码查询下级
     *
     * @param rightLikeOrgRuleCodeList 降维编码集合，右边带“%”
     * @param enableStatus             启用状态
     * @return
     */
    List<MdmProductLevelRespVo> findChildrenByRuleCodeList(@Param("rightLikeOrgRuleCodeList") List<String> rightLikeOrgRuleCodeList, @Param("enableStatus") String enableStatus);

    /**
     * 查询产品层级下拉框选择数据
     *
     * @param page
     * @param reqVo
     * @param underThisRuleCode    只查询当前降维编码全部下级组织
     * @param notUnderThisRuleCode 排除当前降维编码全部下级
     * @return
     */
    List<MdmProductLevelSelectRespVo> findProductLevelSelectList(Page<MdmProductLevelSelectRespVo> page, @Param("vo") MdmProductLevelSelectReqVo reqVo, @Param("underThisRuleCode") String underThisRuleCode, @Param("notUnderThisRuleCode") String notUnderThisRuleCode);

    /**
     * 查询产品层级懒加载数据
     *
     * @param enableStatus    启用状态
     * @param topOnly         传true只查第一层
     * @param parentCode      只查询该编码下一级
     * @param codeList        只查询这些编码
     * @param ruleCodeList    只查询这些降维编码
     * @param excludeRuleCode 排除这个降维编码的下级
     * @return
     */
    List<BaseLazyTreeRespVo> findProductLevelLazyTreeList(@Param("enableStatus") String enableStatus, @Param("topOnly") Boolean topOnly, @Param("parentCode") String parentCode, @Param("codeList") List<String> codeList, @Param("ruleCodeList") List<String> ruleCodeList, @Param("excludeRuleCode") String excludeRuleCode);

    /**
     * 把降维编码刷成id
     */
    void copyIdToRuleCode();

    /**
     * 把不存在的上级编码置成空
     */
    void setNullNotExistParentCode();
}
