package com.biz.crm.productlevel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.*;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;

import java.util.List;

/**
 * 接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 17:47:01
 */
public interface MdmProductLevelService extends IService<MdmProductLevelEntity> {

    /**
     * 列表
     *
     * @param mdmProductLevelReqVo
     * @return PageResult<MdmProductLevelRespVo>
     */
    PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo);

    /**
     * 查询
     *
     * @param id
     * @param productLevelCode
     * @return
     */
    MdmProductLevelRespVo detail(String id, String productLevelCode);

    /**
     * 新增
     *
     * @param mdmProductLevelReqVo
     * @return
     */
    void save(MdmProductLevelReqVo mdmProductLevelReqVo);

    /**
     * 更新
     *
     * @param mdmProductLevelReqVo
     * @return
     */
    void update(MdmProductLevelReqVo mdmProductLevelReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 根据产品层级编码获当前及下级所有层级编码
     *
     * @param productLevelCode 层级编码
     * @return result
     */
    List<String> getCurrentAndSubLevelCode(String productLevelCode);

    /**
     * 重置降维编码
     */
    void resetRuleCode();

    /**
     * 根据id或者编码查询上级产品层级集合
     *
     * @param id               id
     * @param productLevelCode 产品层级编码
     * @return
     */
    List<MdmProductLevelRespVo> getParentList(String id, String productLevelCode);

    /**
     * 根据id或者编码查询上级产品层级集合(cps用)
     * @param id               id
     * @param productLevelCode 产品层级编码
     * @return
     */
    List<MdmProductLevelVo> getParentCpsList(String id, String productLevelCode);

    /**
     * 根据id或者编码查询全部下级产品层级集合
     *
     * @param id               id
     * @param productLevelCode 产品层级编码
     * @return
     */
    List<MdmProductLevelRespVo> getChildrenList(String id, String productLevelCode);

    /**
     * 根据产品层级编码或id查询该层架的全部下级层级编码
     *
     * @param id               产品层级id
     * @param productLevelCode 产品层级编码
     * @return
     */
    List<String> getAllChildrenProductLevelCodeList(String id, String productLevelCode);

    /**
     * 产品层级下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmProductLevelSelectRespVo> productLevelSelectList(MdmProductLevelSelectReqVo reqVo);

    /**
     * 根据产品层级编码集合获取产品层级详情redis缓存数据
     *
     * @param orgCodeList 产品层级编码集合
     * @return
     */
    List<MdmProductLevelRedisVo> findRedisListByProductLevelCodeList(List<String> orgCodeList);

    /**
     * 根据产品层级编码集合获取产品层级上级redis缓存数据
     *
     * @param orgCodeList 产品层级编码集合
     * @return
     */
    List<MdmProductLevelParentChildrenRedisVo> findRedisProductLevelParentListByCodeList(List<String> orgCodeList);

    /**
     * 根据产品层级编码集合获取产品层级下级redis缓存数据
     *
     * @param orgCodeList 产品层级编码集合
     * @return
     */
    List<MdmProductLevelParentChildrenRedisVo> findRedisProductLevelChildrenListByCodeList(List<String> orgCodeList);

    /**
     * 获取全部产品层级redis缓存数据
     *
     * @return
     */
    List<MdmProductLevelReloadRedisVo> findRedisReloadList();

    /**
     * 获取所有产品层级
     *
     * @return
     */
    List<MdmProductLevelRespVo> getAllProductLevelList();
}

