package com.biz.crm.region.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.region.*;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Slf4j
@RestController
@RequestMapping("/mdmRegionController")
@Api(tags = "mdm-行政区域")
@CrmGlobalLog
public class MdmRegionController {
    @Autowired
    private MdmRegionService mdmRegionService;

    @ApiOperation(value = "查询列表（行政区域管理列表使用，其它地方不要用这个接口）")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmRegionRespVo>> pageList(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(mdmRegionService.pageList(mdmRegionReqVo));
    }

    @ApiOperation(value = "查询导出列表")
    @PostMapping("/findExportList")
    @CrmDictMethod
    public Result<PageResult<MdmRegionRespVo>> findExportList(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(mdmRegionService.findExportList(mdmRegionReqVo));
    }

    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<List<MdmRegionRespVo>> list(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(mdmRegionService.findList(mdmRegionReqVo));
    }

    @ApiOperation(value = "查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "regionCode", value = "区域编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmRegionRespVo> query(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "regionCode", required = false) String regionCode) {
        MdmRegionRespVo respVo = mdmRegionService.query(id,regionCode);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        mdmRegionService.save(mdmRegionReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        mdmRegionService.update(mdmRegionReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        mdmRegionService.deleteBatch(mdmRegionReqVo);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        mdmRegionService.enableBatch(mdmRegionReqVo);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        mdmRegionService.disableBatch(mdmRegionReqVo);
        return Result.ok("禁用成功");
    }

    @ApiOperation("区域下拉框")
    @PostMapping("/select")
    public Result<List<MdmRegionSelectRespVo>> select(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(mdmRegionService.select(mdmRegionReqVo));
    }

    @ApiOperation("区域下拉框（传parentCode查该编码下级，不传查询国家，regionName模糊查询）")
    @PostMapping("/selectStartWithCountry")
    public Result<List<MdmRegionSelectRespVo>> selectStartWithCountry(@RequestBody MdmRegionSelectReqVo reqVo) {
        return Result.ok(mdmRegionService.selectStartWithCountry(reqVo));
    }

    @ApiOperation("区域下拉框（传parentCode查该编码下级，不传查询省份，regionName模糊查询）")
    @PostMapping("/selectStartWithProvince")
    public Result<List<MdmRegionSelectRespVo>> selectStartWithProvince(@RequestBody MdmRegionSelectReqVo reqVo) {
        return Result.ok(mdmRegionService.selectStartWithProvince(reqVo));
    }

    @ApiOperation("行政区域下拉框单独下拉框，返回格式如（中国/四川省/成都市/武侯区）")
    @PostMapping("/regionSelect")
    public Result<List<MdmRegionSelectRespVo>> regionSelect(@RequestBody MdmRegionSelectReqVo reqVo) {
        return Result.ok(mdmRegionService.regionSelect(reqVo));
    }

    @ApiOperation("获取行政区域国家和乡镇显影控制")
    @GetMapping("/getRegionShowControl")
    public Result<MdmRegionShowControlRespVo> getRegionShowControl() {
        MdmRegionShowControlRespVo reqVo = new MdmRegionShowControlRespVo();
        reqVo.setCountryShow(ParamUtil.getParameterValue(ParameterParam.MDM_REGION_SHOW_CONTROL_COUNTRY));
        reqVo.setTownshipShow(ParamUtil.getParameterValue(ParameterParam.MDM_REGION_SHOW_CONTROL_TOWNSHIP));
        return Result.ok(reqVo);
    }

//    @ApiOperation("重置降维编码")
//    @PostMapping("/resetRuleCode")
//    public Result resetRuleCode() {
//        mdmRegionService.resetRuleCode();
//        return Result.ok();
//    }
}
