package com.biz.crm.region.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-08 13:59
 **/
public class MdmRegionProvider {

    public String pageListProvider(Map<String,Object> map){
        MdmRegionReqVo vo = (MdmRegionReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("*");
            FROM("mdm_region a");
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status=#{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getId())){
                WHERE("a.id=#{vo.id}");
            }
            if(StringUtils.isNotEmpty(vo.getRegionLevel())){
                WHERE("a.region_level=#{vo.regionLevel}");
            }
            if(StringUtils.isNotEmpty(vo.getParentCode())){
                WHERE("a.parent_code=#{vo.parentCode}");
            }
            if(StringUtils.isNotEmpty(vo.getRegionCode())){
                WHERE("a.region_code like " + ProviderUtil.bindPercent(vo.getRegionCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRegionName())){
                WHERE("a.region_name like " + ProviderUtil.bindPercent(vo.getRegionName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("region_code asc");
        }}.toString();
    }
}
