package com.biz.crm.region.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.region.model.MdmRegionEntity;

import java.util.List;
import java.util.Map;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
public interface MdmRegionService extends IService<MdmRegionEntity> {

    PageResult<MdmRegionRespVo> pageList(MdmRegionReqVo mdmRegionReqVo);

    PageResult<MdmRegionRespVo> findExportList(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 列表
     * @param mdmRegionReqVo
     * @return PageResult<MdmRegionRespVo>
     */
    List<MdmRegionRespVo> findList(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 查询
     * @param mdmRegionReqVo
     * @return MdmRegionRespVo
     */
    MdmRegionRespVo query(String id,String regionCode);

    /**
     * 根据code查name(腾讯用户同步
     * @param regionCode
     * @return
     */
    String queryByName(String regionCode);


    /**
     * 新增
     * @param mdmRegionReqVo
     * @return
     */
    void save(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 更新
     * @param mdmRegionReqVo
     * @return
     */
    void update(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 删除
     * @param mdmRegionReqVo
     * @return
     */
    void deleteBatch(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 启用
     * @param mdmRegionReqVo
     * @return
     */
    void enableBatch(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 禁用
     * @param mdmRegionReqVo
     * @return
     */
    void disableBatch(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 区域下拉框
     * @param mdmRegionReqVo vo
     * @return list
     */
    List<MdmRegionSelectRespVo> select(MdmRegionReqVo mdmRegionReqVo);

    /**
     * 区域下拉框（传parentCode查该编码下级，不传查询国家，regionName模糊查询）
     *
     * @param reqVo
     * @return
     */
    List<MdmRegionSelectRespVo> selectStartWithCountry(MdmRegionSelectReqVo reqVo);

    /**
     * 区域下拉框（传parentCode查该编码下级，不传查询国家，regionName模糊查询）
     *
     * @param reqVo
     * @return
     */
    List<MdmRegionSelectRespVo> selectStartWithProvince(MdmRegionSelectReqVo reqVo);

    /**
     * 行政区域下拉框单独下拉框，返回格式如（中国/四川省/成都市/武侯区）
     *
     * @param reqVo
     * @return
     */
    List<MdmRegionSelectRespVo> regionSelect(MdmRegionSelectReqVo reqVo);

    /**
     * 根据行政区域编码获取编码名称map
     *
     * @param regionCodeList
     * @return
     */
    Map<String, String> getRegionCodeNameMap(List<String> regionCodeList);

//    /**
//     * 重置降维编码
//     */
//    void resetRuleCode();
}

