package com.biz.crm.role.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleSelectRespVo;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.provider.MdmRoleProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * @author liaohua
 * @Description: 角色管理持久层
 * @date 2020/10/2211:34 上午
 */
public interface MdmRoleMapper extends BaseMapper<MdmRoleEntity> {


    /**
     * 列表查询
     *
     * @param vo
     * @return
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_position_role where role_code=a.role_code and position_code in",
            extOrgSql = "select 1 from mdm_position p join mdm_org o on p.org_code=o.org_code join mdm_position_role pr on pr.position_code=p.position_code where a.role_code=pr.role_code and p.org_code in"
    )
    List<MdmRoleRespVo> findList(Page<MdmRoleReqVo> page, @Param("vo") MdmRoleReqVo vo);

    /**
     * 列表查询(provider)
     *
     * @param vo
     * @return
     */
    @SelectProvider(type = MdmRoleProvider.class,method = "findListProvider")
    List<MdmRoleRespVo> findListProvider(Page<MdmRoleReqVo> page, @Param("vo") MdmRoleReqVo vo);


    /**
     * 查询角色下拉框选择数据
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_position_role where role_code=a.role_code and position_code in",
            extOrgSql = "select 1 from mdm_position p join mdm_org o on p.org_code=o.org_code join mdm_position_role pr on pr.position_code=p.position_code where a.role_code=pr.role_code and p.org_code in"
    )
    List<MdmRoleSelectRespVo> roleSelectList(Page<MdmRoleSelectRespVo> page, @Param("vo") MdmRoleSelectReqVo reqVo);

    /**
     * 根据用户查询角色列表
     * @param mdmUserRoleReqVo vo
     * @return list
     */
    List<MdmRoleRespVo> obtainUserRoleList(@Param("vo") MdmUserRoleReqVo mdmUserRoleReqVo);
}
