package com.biz.crm.role.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.role.req.*;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleSelectRespVo;
import com.biz.crm.role.mode.MdmRoleEntity;

import java.util.List;

/**
 * @author liaohua
 * @date 2020/10/22 11:27 上午
 */
public interface MdmRoleService extends IService<MdmRoleEntity> {
    /**
     * 列表
     *
     * @param mdmRoleReqVo privilege
     * @return PageResult<MdmProductLevelRespVo>
     */
    PageResult<MdmRoleRespVo> findList(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 查询
     *
     * @param mdmRoleReqVo privilege
     * @return MdmTerminalRespVo
     */
    MdmRoleRespVo detail(String id, String roleCode);

    /**
     * 根据角色编码批量查询角色主表
     *
     * @param roleCodeList
     * @return
     */
    List<MdmRoleRespVo> queryBatchByRoleCodeList(List<String> roleCodeList);

    /**
     * 新增
     *
     * @param mdmRoleReqVo privilege
     */
    void save(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 更新
     *
     * @param mdmRoleReqVo privilege
     */
    void update(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 删除
     *
     * @param mdmRoleReqVo privilege
     */
    void deleteBatch(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 启用
     *
     * @param mdmRoleReqVo privilege
     */
    void enableBatch(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 禁用
     *
     * @param mdmRoleReqVo privilege
     */
    void disableBatch(MdmRoleReqVo mdmRoleReqVo);


    /**
     * 条件查询列表
     *
     * @param mdmRoleReqVo privilege
     * @return list
     */
    List<MdmRoleRespVo> roleList(MdmRoleReqVo mdmRoleReqVo);

    /**
     * 角色下拉框列表
     *
     * @param reqVo
     * @return
     */
    List<MdmRoleSelectRespVo> roleSelectList(MdmRoleSelectReqVo reqVo);

    /**
     * 角色关联的菜单树
     * @param mdmRoleFunctionReqVo vo
     * @return vo
     */
    MdmRoleFunctionRespVo roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo);

    /**
     * 角色关联的按钮
     * @param mdmRoleSubButtonReqVo vo
     * @return list
     */
    List<MdmRoleSubButtonVo> roleButtonList(MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo);

    /**
     * 保存菜单与按钮
     * @param mdmRoleFunctionButtonStoreVo vo
     */
    void saveFunctionButton(MdmRoleFunctionButtonStoreVo mdmRoleFunctionButtonStoreVo);

    /**
     * 切换当前及下级菜单关联按钮状态
     * @param mdmSwitchFunctionButtonReqVo vo
     */
    void switchFunctionButton(MdmSwitchFunctionButtonReqVo mdmSwitchFunctionButtonReqVo);

    List<String> getRoleByUserName(String userName, String positionCode);

    /**
     * 根据用户账号查询用户的权限角色
     *
     * @param userName
     * @return
     */
    List<String> getRoleByUserName(String userName);

    /**
     * 根据用户获取角色列表
     * @param mdmUserRoleReqVo vo
     * @return list
     */
    List<MdmRoleRespVo> obtainUserRoleList(MdmUserRoleReqVo mdmUserRoleReqVo);
}
