package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmUnbindRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRelationPositionPageRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.role.mapper.MdmRoleRelationPositionMapper;
import com.biz.crm.role.service.MdmRoleRelationPositionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class MdmRoleRelationPositionServiceImpl implements MdmRoleRelationPositionService {

    @Resource
    private MdmRoleRelationPositionMapper mdmRoleRelationPositionMapper;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionNotRelateAnyRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Page<MdmRoleRelationPositionPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> list = mdmRoleRelationPositionMapper.findPositionNotRelateAnyRoleList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmRoleRespVo>> map = mdmPositionRoleService.getPositionRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List<MdmRoleRespVo> bpmRoleList = map.get(item.getPositionCode());
                    item.setRoleCode(bpmRoleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleName(bpmRoleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.<MdmRoleRelationPositionPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionNotRelateCurRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText(reqVo.getRoleCode(), "缺失角色编码");
        Page<MdmRoleRelationPositionPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> list = mdmRoleRelationPositionMapper.findPositionNotRelateCurRoleList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmRoleRespVo>> map = mdmPositionRoleService.getPositionRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List<MdmRoleRespVo> bpmRoleList = map.get(item.getPositionCode());
                    item.setRoleCode(bpmRoleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleName(bpmRoleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.<MdmRoleRelationPositionPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionHasRelateCurRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText(reqVo.getRoleCode(), "缺失角色编码");
        Page<MdmRoleRelationPositionPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> list = mdmRoleRelationPositionMapper.findPositionHasRelateCurRoleList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmRoleRespVo>> map = mdmPositionRoleService.getPositionRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List<MdmRoleRespVo> bpmRoleList = map.get(item.getPositionCode());
                    item.setRoleCode(bpmRoleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleName(bpmRoleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.<MdmRoleRelationPositionPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void positionRelationRole(MdmRoleRelationPositionReqVo reqVo) {
        Assert.hasText(reqVo.getRoleCode(), "缺失角色编码");
        Assert.notEmpty(reqVo.getPositionCodeList(), "缺失职位编码");
        mdmPositionRoleService.addPosition(reqVo.getPositionCodeList(), reqVo.getRoleCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceBindRole(MdmRoleRelationPositionReqVo reqVo) {
        Assert.hasText(reqVo.getRoleCode(), "缺失角色编码");
        Assert.hasText(reqVo.getOriginRoleCode(), "缺失原角色编码");
        Assert.notEmpty(reqVo.getPositionCodeList(), "缺失职位编码");
        mdmPositionRoleService.replacePositionsRole(reqVo.getPositionCodeList(), reqVo.getOriginRoleCode(), reqVo.getRoleCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unbindRelationRole(MdmUnbindRoleRelationPositionReqVo reqVo) {
        Assert.hasText(reqVo.getRoleCode(), "缺失角色编码");
        Assert.notEmpty(reqVo.getPositionCodeList(), "缺失职位编码");
        mdmPositionRoleService.removeRolePositions(reqVo.getRoleCode(), reqVo.getPositionCodeList());
    }
}
        