package com.biz.crm.shoppingcart.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @Description: 删除商品
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.CLEAR_SHOPPING_CAR,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.CLEAR_SHOPPING_CAR_CONSUMER + "${rocketmq.environment-variable}")
public class ClearShopingCarConsumer extends AbstractRocketMQConsumer {

    @Resource
    private ShoppingCartService shoppingCartService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("删除商品开始------------------------");
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            log.info("消息为空------------------------");
            return "消息为空!";
        }
        log.info("商品编码{}",msg);
        OrderVo orderVo = JsonPropertyUtil.toObject(msg,OrderVo.class);
        if(orderVo == null || CollectionUtil.listEmpty(orderVo.getGroupItemVos())){
            log.info("商品列表为空------------------------");
            return "商品列表为空!";
        }
        List<String> productCodes = Lists.newArrayList();
        orderVo.getGroupItemVos().forEach(group -> {
            if(CollectionUtil.listNotEmpty(group.getNormalList())) {
                group.getNormalList().forEach(d -> {
                    productCodes.add(d.getProductCode());
                });
            }
        });
        this.shoppingCartService.clearShoppingCar(orderVo.getCusCode(), productCodes);
        log.info("清空购物车结束------------------------");
        return "操作成功";
    }
}
