package com.biz.crm.shoppingcart.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**购物车
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/25 17:00
 **/
@Api(value = "微信端-购物车-客户", tags = "微信端-购物车-客户")
@RestController
@RequestMapping("/v/shoppingcart")
public class ShoppingCartvController {

    @Resource
    private ShoppingCartService shoppingCartService;

    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody ShoppingCartVo shoppingCartVo){
        UserRedis userRedis = UserUtils.getUser();
        shoppingCartVo.setCusCode(userRedis.getCustcode());
        shoppingCartVo.setAccount(userRedis.getUsername());
        shoppingCartService.add(shoppingCartVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "调整购物车商品数量")
    @PostMapping(value = "adjustNum")
    public Result adjustNum(@RequestBody ShoppingCartVo shoppingCartVo){
        shoppingCartVo.setCusCode(UserUtils.getUser().getCustcode());
        shoppingCartService.adjustNum(shoppingCartVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "列表展示（按发货公司分组）")
    @PostMapping(value = "list")
    public Result<Map<String, List<ShoppingCartVo>>> list(){
        UserRedis userRedis = UserUtils.getUser();
        ShoppingCartVo shoppingCartVo = new ShoppingCartVo();
        shoppingCartVo.setCusCode(userRedis.getCustcode());
        return Result.ok(shoppingCartService.list(shoppingCartVo));
    }

    @CrmLog
    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result delByIds(@RequestBody List<String> ids){
        shoppingCartService.delByIds(ids, UserUtils.getUser().getCustcode());
        return Result.ok();
    }

}
