package com.biz.crm.sync.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.sync.MdmSyncFunctionReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardFunctionReqVo;
import com.biz.crm.sync.service.MdmFunctionSyncService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * 菜单同步
 *
 * @author zxw
 * @date 2021-05-27 10:37
 **/
@RequestMapping("/mdmFunctionSyncController")
@RestController
@CrmGlobalLog
@Api(tags = "MDM-菜单同步")
public class MdmFunctionSyncController {

    @Autowired
    private MdmFunctionSyncService mdmFunctionSyncService;

    @ApiOperation("菜单同步")
    @PostMapping("/functionSync")
    public Result<Object> functionSync(@RequestBody @Valid MdmSyncFunctionReqVo mdmSyncFunctionReqVo) {
        mdmFunctionSyncService.functionSync(mdmSyncFunctionReqVo);
        return Result.ok();
    }

    @ApiOperation("同步标品环境菜单")
    @PostMapping("/functionBaseSync")
    public Result<Object> functionBaseSync(@RequestBody MdmSyncStandardFunctionReqVo mdmSyncStandardFunctionReqVo) {
        MdmSyncFunctionReqVo mdmSyncFunctionReqVo = new MdmSyncFunctionReqVo();
        mdmSyncFunctionReqVo.setCurrentAndSubFunctionCodeList(mdmSyncStandardFunctionReqVo.getCurrentAndSubFunctionCodeList());
        mdmSyncFunctionReqVo.setFunctionCodeList(mdmSyncStandardFunctionReqVo.getFunctionCodeList());
        mdmSyncFunctionReqVo.setDeleted(mdmSyncStandardFunctionReqVo.getDeleted());
        mdmFunctionSyncService.functionSync(mdmSyncFunctionReqVo);
        return Result.ok();
    }


}
