package com.biz.crm.sync.service.impl;

import com.biz.crm.annotation.Klock;
import com.biz.crm.common.param.CacheManagerConstant;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubButtonRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncFunctionReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmFunctionSyncService;
import com.biz.crm.tableconfig.manager.MdmColumnConfigConverter;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 菜单同步
 *
 * @author zxw
 * @date 2021-05-27 11:03
 **/
@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmFunctionSyncServiceExpandImpl")
public class MdmFunctionSyncServiceImpl implements MdmFunctionSyncService {

    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmFunctionService mdmFunctionService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Autowired
    private RedisService redisService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock
    public void functionSync(MdmSyncFunctionReqVo mdmSyncFunctionReqVo) {
        List<String> functionCodeList = mdmSyncFunctionReqVo.getFunctionCodeList();

        //备份本地数据，并删除
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(mdmSyncFunctionReqVo.getDeleted())) {
            backUpFunction();
            backUpFunctionSub();
            backUpFunctionSubButton();
            backUpColumn();
        }

        //同步菜单
        MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo = MdmSyncParameterParser.obtainOriginalData(mdmSyncFunctionReqVo, mdmSyncProperty
                , "/mdm/mdmfunction/syncList", mdmSyncFunctionReqVo, MdmFunctionEngineSyncVo.class);
        saveFunction(mdmFunctionEngineSyncVo);
        saveListConfig(functionCodeList, mdmFunctionEngineSyncVo);
        saveButton(functionCodeList, mdmFunctionEngineSyncVo);
        saveColumn(functionCodeList, mdmFunctionEngineSyncVo);
        try {
            redisService.delBatch(CacheManagerConstant.MDM_COLUMN+":*");
            redisService.delBatch(CacheManagerConstant.MDM_FUNCTION_SUB+":*");
            redisService.delBatch(CacheManagerConstant.MDM_BUTTON+":*");
        } catch (Exception e) {
            log.info("清除缓存失败,需要手动清除button,column缓存");
        }
    }

    protected void backUpColumn() {
        List<MdmColumnConfigEntity> list = mdmColumnConfigService.lambdaQuery().list();
        if(!CollectionUtils.isEmpty(list)){
            redisService.lSetAll(CacheManagerConstant.MDM_COLUMN + ":bak", list, RedisParam.SECONDS_OF_MONTH);
            mdmColumnConfigService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunctionSubButton() {
        List<MdmFunctionSubButtonEntity> list = mdmFunctionSubButtonService.lambdaQuery().list();
        if(!CollectionUtils.isEmpty(list)){
            redisService.lSetAll(CacheManagerConstant.MDM_FUNCTION_SUB_BUTTON + ":bak", list, RedisParam.SECONDS_OF_MONTH);
            mdmFunctionSubButtonService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunctionSub() {
        List<MdmFunctionSubEntity> list = mdmFunctionSubService.lambdaQuery().list();
        if(!CollectionUtils.isEmpty(list)){
            redisService.lSetAll(CacheManagerConstant.MDM_FUNCTION_SUB+":bak",list, RedisParam.SECONDS_OF_MONTH);
            mdmFunctionSubService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunction() {
        List<MdmFunctionEntity> list = mdmFunctionService.lambdaQuery().list();
        if(!CollectionUtils.isEmpty(list)){
            redisService.lSetAll(CacheManagerConstant.MDM_FUNCTION + ":bak", list, RedisParam.SECONDS_OF_MONTH);
            mdmFunctionService.lambdaUpdate().remove();
        }
    }

    protected void saveColumn(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        //导入字段
        List<MdmColumnConfigRespVo> columnConfigRespVoList = mdmFunctionEngineSyncVo.getMdmColumnConfigRespVoList();
        if(!CollectionUtils.isEmpty(columnConfigRespVoList)){
//            List<String> columnKeyList = mdmColumnConfigService.lambdaQuery()
//                    .in(!CollectionUtils.isEmpty(functionCodeList), MdmColumnConfigEntity::getParentCode, functionCodeList)
//                    .select(MdmColumnConfigEntity::getParentCode, MdmColumnConfigEntity::getFunctionCode, MdmColumnConfigEntity::getField)
//                    .list()
//                    .stream()
//                    .map(x -> x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getField())
//                    .collect(Collectors.toList());
//            List<MdmColumnConfigEntity> configEntities = columnConfigRespVoList.stream()
//                    .filter(x -> !columnKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getField()))
//                    .map(MdmColumnConfigConverter.INSTANCE::reqVo2Entity)
//                    .peek(x -> x.setId(null))
//                    .collect(Collectors.toList());
            List<MdmColumnConfigEntity> configEntities = MdmColumnConfigConverter.INSTANCE.respVo2Entity(columnConfigRespVoList);
            if(!CollectionUtils.isEmpty(configEntities)){
                mdmColumnConfigService.saveOrUpdateBatch(configEntities);
            }
        }
    }

    protected void saveButton(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        //导入按钮
        List<MdmFunctionSubButtonRespVo> subButtonRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubButtonRespVoList();
        if(!CollectionUtils.isEmpty(subButtonRespVoList)){
//            List<String> buttonKeyList = mdmFunctionSubButtonService.lambdaQuery()
//                    .in(!CollectionUtils.isEmpty(functionCodeList), MdmFunctionSubButtonEntity::getParentCode, functionCodeList)
//                    .select(MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode)
//                    .list()
//                    .stream()
//                    .map(x -> x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getButtonCode())
//                    .collect(Collectors.toList());
//            List<MdmFunctionSubButtonEntity> buttonEntityList = subButtonRespVoList.stream()
//                    .filter(x -> !buttonKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getButtonCode()))
//                    .map(x -> CrmBeanUtil.copy(x, MdmFunctionSubButtonEntity.class))
//                    .peek(x -> x.setId(null))
//                    .collect(Collectors.toList());
            List<MdmFunctionSubButtonEntity> buttonEntityList = CrmBeanUtil.copyList(subButtonRespVoList, MdmFunctionSubButtonEntity.class);
            if(!CollectionUtils.isEmpty(buttonEntityList)){
                mdmFunctionSubButtonService.saveOrUpdateBatch(buttonEntityList);
            }
        }
    }

    protected void saveListConfig(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        //导入指定列表
        List<MdmFunctionSubRespVo> mdmFunctionSubRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubRespVoList();
        Assert.notEmpty(mdmFunctionSubRespVoList, "列表缺失");
//        List<String> functionSubKeyList = mdmFunctionSubService.lambdaQuery()
//                .in(!Collections.isEmpty(functionCodeList), MdmFunctionSubEntity::getParentCode,functionCodeList)
//                .select(MdmFunctionSubEntity::getParentCode, MdmFunctionSubEntity::getFunctionCode)
//                .list()
//                .stream()
//                .filter(x -> x != null && !StringUtils.isEmpty(x.getParentCode()) && !StringUtils.isEmpty(x.getFunctionCode()))
//                .map(x -> x.getParentCode() + ":" + x.getFunctionCode())
//                .collect(Collectors.toList());
//        List<MdmFunctionSubEntity> mdmFunctionSubEntityList = mdmFunctionSubRespVoList.stream()
//                .filter(x -> !functionSubKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode()))
//                .map(x -> CrmBeanUtil.copy(x, MdmFunctionSubEntity.class))
//                .peek(x->x.setId(null))
//                .collect(Collectors.toList());
        List<MdmFunctionSubEntity> mdmFunctionSubEntityList = CrmBeanUtil.copyList(mdmFunctionSubRespVoList, MdmFunctionSubEntity.class);
        log.info("导入列表集合:{}",mdmFunctionSubEntityList);
        if(!CollectionUtils.isEmpty(mdmFunctionSubEntityList)){
            mdmFunctionSubService.saveOrUpdateBatch(mdmFunctionSubEntityList);
        }
    }

    protected void saveFunction(MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List<MdmFunctionRespVo> mdmFunctionRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionRespVoList();
        Assert.notEmpty(mdmFunctionRespVoList, "菜单缺失");
//        List<String> functionKeyList = mdmFunctionService.lambdaQuery()
//                .select(MdmFunctionEntity::getFunctionCode)
//                .list()
//                .stream()
//                .filter(x->x!=null&&!StringUtils.isEmpty(x.getFunctionCode()))
//                .map(MdmFunctionEntity::getFunctionCode)
//                .collect(Collectors.toList());
//
//        List<MdmFunctionEntity> mdmFunctionEntities = mdmFunctionRespVoList.stream()
//                .filter(x -> !functionKeyList.contains(x.getFunctionCode()))
//                .map(x -> CrmBeanUtil.copy(x, MdmFunctionEntity.class))
//                .peek(x->x.setId(null))
//                .collect(Collectors.toList());
        List<MdmFunctionEntity> mdmFunctionEntities = CrmBeanUtil.copyList(mdmFunctionRespVoList, MdmFunctionEntity.class);
        log.info("导入菜单集合:{}",mdmFunctionEntities);
        if(!CollectionUtils.isEmpty(mdmFunctionEntities)){
            mdmFunctionService.saveOrUpdateBatch(mdmFunctionEntities);
        }
    }
}
