package com.biz.crm.sys.index.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.sys.MdmIndexConfigVo;
import com.biz.crm.sys.index.entity.MdmIndexConfigEntity;
import com.biz.crm.sys.index.service.MdmIndexConfigService;
import com.biz.crm.sys.index.vo.MdmIndexConfigStopOrOpenOrDeleteVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sys.index.controller
 * @Description: TODO
 * @date 2020/11/24 下午12:51
 */
@Api(value = "系统首页配置", tags = "系统首页配置")
@RestController
@RequestMapping("/sys/mdmIndexConfigController")
public class MdmIndexConfigController {
    @Autowired
    private MdmIndexConfigService mdmIndexConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "分页查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmIndexConfigVo>> list(@RequestBody MdmIndexConfigVo vo) {
        PageResult<MdmIndexConfigVo> result = mdmIndexConfigService.findList(vo);
        return Result.ok(result);
    }

    @ApiOperation(value = "启用或停用")
    @PostMapping("/stopOrOpen")
    @CrmLog
    public Result stopOrOpen(@RequestBody MdmIndexConfigStopOrOpenOrDeleteVo vo) {
        mdmIndexConfigService.stopOrOpen(vo);
        return Result.ok();
    }


    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmIndexConfigService.delete(ids);
        return Result.ok();
    }


    @ApiOperation(value = "详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmLog
    public Result<MdmIndexConfigVo> detail(@RequestParam("id") String id) {
        Result<MdmIndexConfigVo> result = new Result<>();
        MdmIndexConfigVo mdmIndexConfigVo = mdmIndexConfigService.detail(id);
        result.setResult(mdmIndexConfigVo);
        return result;
    }

    @ApiOperation(value = "保存或者修改", httpMethod = "POST")
    @PostMapping("/saveOrUpdate")
    @CrmLog
    public Result<MdmIndexConfigVo> saveOrUpdateEntity(@RequestBody MdmIndexConfigVo mdmIndexConfigVo) {
        Result<MdmIndexConfigVo> result = new Result<>();
        mdmIndexConfigService.saveOrUpdateEntity(mdmIndexConfigVo);
        return result;
    }

    @ApiOperation(value = "查询配置", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dataType", value = "dataType", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/config")
    @CrmLog
    public Result<MdmIndexConfigVo> config(@RequestParam("dataType") String dataType){
        Result<MdmIndexConfigVo> result = new Result<>();
        QueryWrapper<MdmIndexConfigEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("enable_status", CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq("data_type",dataType);
        List<MdmIndexConfigEntity> list =  mdmIndexConfigService.list(queryWrapper);
        if(CollectionUtil.listNotEmptyNotSizeZero(list)){
            MdmIndexConfigVo mdmIndexConfigVo = mdmIndexConfigService.detail(list.get(0).getId());
            result.setResult(mdmIndexConfigVo);
        }else {
            result.error500("未配置参数");
        }
        return result;
    }

}
