package com.biz.crm.tableconfig.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalBatchReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.tableconfig.service.MdmColumnConfigPersonalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 字段配置个性设置
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Slf4j
@RestController
@RequestMapping("/mdmColumnConfigPersonalController")
@Api(tags = "字段配置个性设置")
public class MdmColumnConfigPersonalController {

    @Autowired
    private MdmColumnConfigPersonalService mdmColumnConfigPersonalService;

    @ApiOperation(value = "查询个性设置字段列表")
    @PostMapping("/findColumnConfigPersonalList")
    @CrmLog
    public Result<List<MdmColumnConfigPersonalRespVo>> findColumnConfigPersonalList(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
        return Result.ok(mdmColumnConfigPersonalService.findColumnConfigPersonalList(reqVo));
    }

    @ApiOperation(value = "保存个性设置")
    @PostMapping("/saveColumnConfigPersonal")
    @CrmLog
    public Result saveColumnConfigPersonal(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
        mdmColumnConfigPersonalService.saveColumnConfigPersonal(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "删除个性设置")
    @PostMapping("/deleteColumnConfigPersonal")
    @CrmLog
    public Result deleteColumnConfigPersonal(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
        mdmColumnConfigPersonalService.deleteColumnConfigPersonal(reqVo);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "（请勿调用）redis缓存查询接口", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parentCode", value = "菜单编码", required = true, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "functionCode", value = "功能编码", required = true, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "positionCode", value = "职位编码", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/findColumnConfigPersonalRedisList")
    public Result<List<MdmColumnConfigPersonalRedisVo>> findColumnConfigPersonalRedisList(@RequestParam(value = "parentCode", required = true) String parentCode, @RequestParam(value = "functionCode", required = true) String functionCode, @RequestParam(value = "positionCode", required = true) String positionCode) {
        return Result.ok(mdmColumnConfigPersonalService.findColumnConfigPersonalRedisList(parentCode, functionCode, positionCode));
    }
}
