package com.biz.crm.tableconfig.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.Result;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 下级菜单表
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
@Slf4j
@RestController
@RequestMapping("/mdmfunctionsub")
@Api(tags = "功能列表")
public class MdmFunctionSubController {
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;

    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询可配置分页菜单列表")
    @PostMapping("/page")
    @CrmLog
    public Result<PageResult<MdmFunctionRespVo>> page(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        PageResult<MdmFunctionRespVo> result = mdmFunctionSubService.functionPage(mdmFunctionReqVo);
        return Result.ok(result);
    }


    @ApiOperation(value = "查询可配置的菜单树")
    @PostMapping("/configTree")
    public Result<List<MdmFunctionRespVo>> configTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> list = mdmFunctionSubService.configTree(mdmFunctionReqVo);
        return Result.ok(list);
    }

    @ApiOperation("页面引擎动态导出专用查询")
    @PostMapping("/dynamicExportSearch")
    public Result<PageResult<JsonNode>> dynamicExportSearch(@RequestBody MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        return Result.ok(mdmFunctionSubButtonService.dynamicExportSearch(mdmFunctionSubButtonReqVo));
    }

    @ApiOperation("功能列表添加按钮")
    @PostMapping("/buttonSetUp")
    public Result<Object> buttonSetUp(@RequestBody MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        mdmFunctionSubService.buttonSetUp(mdmFunctionSubButtonReqVo);
        return Result.ok();
    }

    @ApiOperation("功能列表查询按钮")
    @PostMapping("/buttonList")
    public Result<List<MdmButtonConfigRespVo>> buttonList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        List<MdmButtonConfigRespVo> list = mdmFunctionSubService.buttonList(mdmFunctionSubReqVo);
        return Result.ok(list);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @ApiOperation("功能列表查询按钮")
    @GetMapping("/buttonQuery")
    public Result<MdmButtonConfigRespVo> buttonQuery(@RequestParam("id") String id) {
        MdmButtonConfigRespVo mdmFunctionSubReqVo = mdmFunctionSubService.buttonQuery(id);
        return Result.ok(mdmFunctionSubReqVo);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "按钮id集合", required = true, paramType = "body")
    })
    @ApiOperation("功能列表按钮删除")
    @PostMapping("/buttonRemove")
    public Result<Object> buttonRemove(@RequestBody List<String> ids) {
        mdmFunctionSubService.buttonRemove(ids);
        return Result.ok();
    }

    @ApiOperation("根据列表编码和菜单编码查询已配置的权限对象")
    @PostMapping("/objList")
    public Result<List<MdmPermissionObjRespVo>> objList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        List<MdmPermissionObjRespVo> list = mdmFunctionSubService.objList(mdmFunctionSubReqVo);
        return Result.ok(list);
    }

    @ApiOperation("权限对象范围列表保存")
    @PostMapping("/saveObj")
    public Result<Object> saveObj(@RequestBody MdmPermissionObjReqVo mdmPermissionObjReqVo) {
        mdmFunctionSubService.saveObj(mdmPermissionObjReqVo);
        return Result.ok();
    }

    @ApiOperation("根据上级编码查询功能列表")
    @PostMapping("/sub_list")
    public Result<List<MdmFunctionSubRespVo>> findSubList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        return Result.ok(mdmFunctionSubService.findSubList(mdmFunctionSubReqVo));
    }

    @ApiOperation("根据上级编码查询功能分页列表")
    @PostMapping("/findSubPage")
    public Result<PageResult<MdmFunctionSubRespVo>> findSubPage(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        return Result.ok(mdmFunctionSubService.findList(mdmFunctionSubReqVo));
    }

    @ApiOperation("根据上级菜单查询配置权限的功能列表(数据权限专用)")
    @PostMapping("/findAuthorizedSubList")
    public Result<List<MdmFunctionSubPermissionVo>> findAuthorizedSubList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        return Result.ok(mdmFunctionSubService.findAuthorizedSubList(mdmFunctionSubReqVo));
    }

    @ApiOperation("根据菜单编码与功能编码查询")
    @PostMapping("/functionSubSearch")
    public Result<MdmFunctionSubRespVo> functionSubSearch(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        MdmFunctionSubRespVo functionSubSearch = mdmFunctionSubService.functionSubSearch(mdmFunctionSubReqVo);
        return Result.ok(functionSubSearch);
    }

    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    public Result<MdmFunctionSubRespVo> query(@RequestParam(value = "id", required = false) String id) {
        MdmFunctionSubRespVo respVo = mdmFunctionSubService.query(id);
        return Result.ok(respVo);
    }

    @ApiOperation("条件查询")
    @PostMapping("/queryCondition")
    public Result<MdmFunctionSubRespVo> queryCondition(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        MdmFunctionSubRespVo respVo = mdmFunctionSubService.queryCondition(mdmFunctionSubReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        mdmFunctionSubReqVo.setId(null);
        mdmFunctionSubService.save(mdmFunctionSubReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        mdmFunctionSubService.update(mdmFunctionSubReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmFunctionSubService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        mdmFunctionSubService.enableBatch(mdmFunctionSubReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        mdmFunctionSubService.disableBatch(mdmFunctionSubReqVo);
        return Result.ok("禁用成功");
    }
}
