package com.biz.crm.tableconfig.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigBatchVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigRespVo;
import com.biz.crm.tableconfig.service.IMdmTableConfigService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 列表配置
 *
 * @author zxw
 * @date 2020-11-21 14:25:32
 */
@Slf4j
@RestController
@RequestMapping("/mdmtableconfig")
@Api(tags = "列表配置")
public class MdmTableConfigController {
    @Autowired
    private IMdmTableConfigService mdmTableConfigService;

    @ApiOperation(value = "根据菜单编码和功能编码查询列表配置")
    @PostMapping("/query")
    @CrmLog
    public Result<MdmTableConfigRespVo> query(@RequestBody MdmTableConfigReqVo mdmTableConfigReqVo) {
        MdmTableConfigRespVo respVo = mdmTableConfigService.query(mdmTableConfigReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "根据功能编码查询表单配置")
    @PostMapping("/queryFunction")
    @CrmLog
    public Result<MdmTableConfigRespVo> queryFunction(@RequestBody MdmTableConfigReqVo mdmTableConfigReqVo) {
        MdmTableConfigRespVo mdmTableConfigRespVo = mdmTableConfigService.queryFunction(mdmTableConfigReqVo);
        return Result.ok(mdmTableConfigRespVo);
    }

    @ApiOperation("根据菜单编码和功能编码查询表单配置")
    @PostMapping("/form/query")
    @CrmLog
    public Result<List<MdmColumnConfigRespVo>> formQuery(@RequestBody MdmTableConfigReqVo mdmTableConfigReqVo) {
        List<MdmColumnConfigRespVo> respVo = mdmTableConfigService.formQuery(mdmTableConfigReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation("批量查询表单配置")
    @PostMapping("/formBatchQuery")
    @CrmLog
    public Result<List<MdmColumnConfigBatchVo>> formBatchQuery(@RequestBody  List<MdmColumnConfigBatchVo> mdmColumnConfigBatchVos) {
        return Result.ok(mdmTableConfigService.formBatchQuery(mdmColumnConfigBatchVos));
    }

}
