package com.biz.crm.tableconfig.manager;


import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zxw
 */
@Mapper
public interface MdmColumnConfigConverter {

    default String convertBool(Boolean bool) {
        return bool != null && bool ? "1" : "0";
    }

    default Boolean convertStr(String str) {
        return "1".equals(str);
    }

    MdmColumnConfigConverter INSTANCE = Mappers.getMapper(MdmColumnConfigConverter.class);

    /**
     * entity转respVo
     *
     * @param mdmColumnConfigEntity entity
     * @return vo
     */
    MdmColumnConfigRespVo entity2RespVo(MdmColumnConfigEntity mdmColumnConfigEntity);

    /**
     * entity转respVo(集合)
     *
     * @param mdmColumnConfigEntity entity
     * @return list
     */
    List<MdmColumnConfigRespVo> entity2RespVo(List<MdmColumnConfigEntity> mdmColumnConfigEntity);

    /**
     * reqVo转entity
     *
     * @param mdmColumnConfigReqVo vo
     * @return entity
     */
    @Mapping(target = "visible",defaultValue = "1")
    @Mapping(target = "showOverflow",defaultValue = "1")
    @Mapping(target = "searchType",defaultValue = "-1")
    MdmColumnConfigEntity respVo2Entity(MdmColumnConfigRespVo mdmColumnConfigRespVo);

    List<MdmColumnConfigEntity> respVo2Entity(List<MdmColumnConfigRespVo> mdmColumnConfigRespVo);


    /**
     * reqVo转entity
     *
     * @param mdmColumnConfigReqVo vo
     * @return entity
     */
    @Mapping(target = "visible",defaultValue = "1")
    @Mapping(target = "showOverflow",defaultValue = "1")
    @Mapping(target = "searchType",defaultValue = "-1")
    MdmColumnConfigEntity reqVo2Entity(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * reqVo转entity(集合)
     *
     * @param mdmColumnConfigReqVo vo
     * @return list
     */
    List<MdmColumnConfigEntity> reqVo2Entity(List<MdmColumnConfigReqVo> mdmColumnConfigReqVo);

}
