package com.biz.crm.tableconfig.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 下级菜单表接口
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
public interface IMdmFunctionSubService extends IService<MdmFunctionSubEntity> {

    /**
     * 列表
     *
     * @param mdmFunctionSubReqVo
     * @return PageResult<MdmFunctionSubRespVo>
     */
    PageResult<MdmFunctionSubRespVo> findList(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 查询
     * @param id id
     * @return MdmFunctionSubRespVo
     */
    MdmFunctionSubRespVo query(String id);

    /**
     * 新增
     *
     * @param mdmFunctionSubReqVo
     * @return
     */
    void save(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 更新
     *
     * @param mdmFunctionSubReqVo
     * @return
     */
    void update(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 删除
     *
     * @param mdmFunctionSubReqVo
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param mdmFunctionSubReqVo
     * @return
     */
    void enableBatch(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 禁用
     *
     * @param mdmFunctionSubReqVo
     * @return
     */
    void disableBatch(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 分页查询菜单列表
     * @param mdmFunctionReqVo vo
     * @return page
     */
    PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 条件查询功能列表
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubRespVo> findSubList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo);


    /**
     * 查询已配置权限的功能列表集合
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubRespVo> findPermissionList(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 查询功能列表的权限对象配置
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmPermissionObjRespVo> objList(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 权限对象范围列表保存
     * @param mdmPermissionObjReqVo
     */
    void saveObj(MdmPermissionObjReqVo mdmPermissionObjReqVo);

    /**
     * 功能列表添加按钮
     * @param mdmFunctionSubButtonReqVo vo
     */
    void buttonSetUp(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    /**
     * 功能列表查询按钮
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmButtonConfigRespVo> buttonList(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 功能列表按钮删除
     * @param ids id集合
     */
    void buttonRemove(List<String> ids);

    /**
     * 功能列表查询按钮
     * @param id id
     * @return
     */
    MdmButtonConfigRespVo buttonQuery(String id);

    /**
     * 根据菜单编码与功能编码查询
     * @param mdmFunctionSubReqVo
     * @return
     */
    MdmFunctionSubRespVo functionSubSearch(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 条件查询(注意functionCode可能重复)
     * @param mdmFunctionSubReqVo vo
     * @return vo
     */
    MdmFunctionSubRespVo queryCondition(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 查询可配置的菜单树
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> configTree(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 根据上级菜单查询配置权限的功能列表(增加配置回显,数据权限专用)
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubPermissionVo> findAuthorizedSubList(MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 根据上级菜单查询配置权限的功能列表(数据权限专用)
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubPermissionVo> findMdmFunctionSubPermissionVos(MdmFunctionSubReqVo mdmFunctionSubReqVo);
}

