package com.biz.crm.tableconfig.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalBatchReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.tableconfig.model.MdmColumnConfigPersonalEntity;

import java.util.List;

/**
 * 字段配置个性设置接口
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
public interface MdmColumnConfigPersonalService extends IService<MdmColumnConfigPersonalEntity> {

    /**
     * 查询当前职位个性设置字段列表
     *
     * @param reqVo
     * @return
     */
    List<MdmColumnConfigPersonalRespVo> findColumnConfigPersonalList(MdmColumnConfigPersonalBatchReqVo reqVo);

    /**
     * 保存当前职位个性设置
     *
     * @param reqVo
     */
    void saveColumnConfigPersonal(MdmColumnConfigPersonalBatchReqVo reqVo);

    /**
     * 重置当前职位个性设置
     *
     * @param reqVo
     */
    void deleteColumnConfigPersonal(MdmColumnConfigPersonalBatchReqVo reqVo);

    /**
     * 后台移除个性设置
     *
     * @param parentCode
     * @param functionCode
     */
    void deleteColumnConfig(String parentCode, String functionCode);

    /**
     * 查询个性设置redis缓存数据
     *
     * @param parentCode
     * @param functionCode
     * @param positionCode
     * @return
     */
    List<MdmColumnConfigPersonalRedisVo> findColumnConfigPersonalRedisList(String parentCode, String functionCode, String positionCode);
}

