package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.AdminEnum;
import com.biz.crm.eunm.mdm.MdmTableConfigFunctionTypeEnum;
import com.biz.crm.nebular.mdm.constant.TrueOrFalseConstant;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigRespVo;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.tableconfig.mapper.MdmTableConfigMapper;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.model.MdmTableConfigEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.tableconfig.service.IMdmTableConfigService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ColumnConfigPersonalUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.cache.TableConfigUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 页面配置接口实现
 *
 * @author zxw
 * @date 2020-11-21 14:25:32
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmTableConfigServiceExpandImpl")
public class MdmTableConfigServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmTableConfigMapper, MdmTableConfigEntity> implements IMdmTableConfigService {

    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Autowired
    private MdmButtonRoleService mdmButtonRoleService;
    @Autowired
    private MdmRoleService mdmRoleService;

    @Override
    public MdmTableConfigRespVo query(MdmTableConfigReqVo reqVo) {
        MdmTableConfigRespVo resultRespVo = null;
        String parentCode = reqVo.getParentCode();
        Assert.hasText(parentCode, "菜单编码不能为空");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText(functionCode, "功能编码不能为空");
//        Object tableConfig = TableConfigUtil.getTableConfig(parentCode, functionCode);
//        if (tableConfig != null) {
//            if (tableConfig instanceof Collection) {
//                throw new BusinessException("功能编码:" + functionCode + "不是列表配置");
//            }
//            resultRespVo = (MdmTableConfigRespVo) tableConfig;
//        } else {
            MdmFunctionSubEntity mdmFunctionSubEntity = mdmFunctionSubService.lambdaQuery()
                    .eq(MdmFunctionSubEntity::getParentCode, parentCode)
                    .eq(MdmFunctionSubEntity::getFunctionType, MdmTableConfigFunctionTypeEnum.LIST_CONFIG.getCode())
                    .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
                    .one();
            Assert.notNull(mdmFunctionSubEntity, "列表配置不存在");
            resultRespVo = setListConfig(parentCode, functionCode, mdmFunctionSubEntity);
            //缓存
            TableConfigUtil.setTableConfig(parentCode, functionCode, resultRespVo);
//        }

        if (CollectionUtil.listNotEmptyNotSizeZero(resultRespVo.getColumn())) {
            UserRedis user = UserUtils.getUser();
            if (user != null && !StringUtils.isEmpty(user.getPoscode())) {
                List<MdmColumnConfigPersonalRespVo> personalList = ColumnConfigPersonalUtil.getColumnConfigPersonal(parentCode, functionCode, user.getPoscode());
                if (CollectionUtil.listNotEmptyNotSizeZero(personalList)) {
                    final Map<String, MdmColumnConfigPersonalRespVo> map = personalList.stream().collect(Collectors.toMap(MdmColumnConfigPersonalRespVo::getField, v -> v));
                    resultRespVo.getColumn().forEach(item -> {
                        if (!StringUtils.isEmpty(item.getTitle())) {
                            if (!map.containsKey(item.getField())) {
                                item.setFormorder("100");
                            } else {
                                MdmColumnConfigPersonalRespVo personalVo = map.get(item.getField());
                                item.setFormorder(personalVo.getFormOrder());
                                item.setVisible(YesNoEnum.yesNoEnum.ONE.getValue().equals(personalVo.getVisible()));
                            }
                        }
                    });
                    resultRespVo.getColumn().sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder())
                            .map(Integer::valueOf)
                            .orElse(100)));
                }
            }
        }
        return resultRespVo;
    }

    /**
     * 设置列表配置
     * @param parentCode 菜单编码
     * @param functionCode 列表编码
     * @param mdmFunctionSubEntity entity
     * @return vo
     */
    protected MdmTableConfigRespVo setListConfig(String parentCode, String functionCode, MdmFunctionSubEntity mdmFunctionSubEntity) {
        //按钮
        UserRedis user = UserUtils.getUser();
        Assert.notNull(user, "用户不存在，请重新登录");
        String username = user.getUsername();

        MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo = new MdmFunctionSubButtonReqVo();
        mdmFunctionSubButtonReqVo.setParentCode(parentCode);
        mdmFunctionSubButtonReqVo.setFunctionCode(functionCode);
        mdmFunctionSubButtonReqVo.setShowMode(TrueOrFalseConstant.TRUE);
        List<MdmButtonConfigRespVo> mdmButtonConfigRespVos = mdmFunctionSubButtonService.buttonList(mdmFunctionSubButtonReqVo);
        log.debug("[列表配置][按钮列表]:{}", mdmButtonConfigRespVos);
        if (!CollectionUtils.isEmpty(mdmButtonConfigRespVos)) {
            if (!AdminEnum.ADMIN.name().equalsIgnoreCase(username)) {
                List<String> roleCodeList = mdmRoleService.getRoleByUserName(username,user.getPoscode());
                Assert.notEmpty(roleCodeList, "当前用户" + user + "未配置角色");
                if (roleCodeList.stream().noneMatch(x->AdminEnum.ADMIN.name().equalsIgnoreCase(x))) {
                    List<String> buttonCodeList = mdmButtonRoleService.findButtonCodeByRole(roleCodeList, parentCode, functionCode);
                    if (!CollectionUtils.isEmpty(buttonCodeList)) {
                        mdmButtonConfigRespVos = mdmButtonConfigRespVos.stream()
                                .filter(x -> buttonCodeList.contains(x.getButtonCode()))
                                .collect(Collectors.toList());
                    }else{
                        mdmButtonConfigRespVos = Collections.emptyList();
                    }
                }

            }
        }
        //字段
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        mdmColumnConfigReqVo.setParentCode(parentCode);
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        log.debug("[列表配置][字段列表]:{}", mdmColumnConfigRespVos);

        MdmTableConfigRespVo mdmTableConfigRespVo = new MdmTableConfigRespVo();
        mdmTableConfigRespVo.setColumn(mdmColumnConfigRespVos);
        mdmTableConfigRespVo.setButtonVos(mdmButtonConfigRespVos);
        mdmTableConfigRespVo.setUrl(mdmFunctionSubEntity.getApiUrl());
        return mdmTableConfigRespVo;
    }


    @Override
    public List<MdmColumnConfigRespVo> formQuery(MdmTableConfigReqVo mdmTableConfigReqVo) {
        String parentCode = mdmTableConfigReqVo.getParentCode();
        Assert.hasText(parentCode, "菜单编码不能为空");
        String functionCode = mdmTableConfigReqVo.getFunctionCode();
        Assert.hasText(functionCode, "功能编码不能为空");
//        Object tableConfig = TableConfigUtil.getTableConfig(parentCode, functionCode);
//        if (tableConfig != null) {
//            if (!(tableConfig instanceof Collection)) {
//                throw new BusinessException("功能编码:" + functionCode + "不是表单配置");
//            }
//            return ((List<MdmColumnConfigRespVo>) tableConfig);
//        }
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = setupQueryConfig(parentCode, functionCode);
        //缓存
//        TableConfigUtil.setTableConfig(parentCode, functionCode, mdmColumnConfigRespVos);
        return mdmColumnConfigRespVos;
    }

    protected List<MdmColumnConfigRespVo> setupQueryConfig(String parentCode, String functionCode) {
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        mdmColumnConfigReqVo.setParentCode(parentCode);
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        if (CollectionUtils.isEmpty(mdmColumnConfigRespVos)) {
            mdmColumnConfigRespVos = mdmColumnConfigRespVos.stream().peek(x -> {
                if (StringUtils.isEmpty(x.getFormvalue())) {
                    x.setFormvalue("");
                }
                if (StringUtils.isEmpty(x.getType())) {
                    x.setType("input");
                }
            }).collect(Collectors.toList());
        }
        return mdmColumnConfigRespVos;
    }

    @Override
    public MdmTableConfigRespVo queryFunction(MdmTableConfigReqVo mdmTableConfigReqVo) {
        String functionCode = mdmTableConfigReqVo.getFunctionCode();
        Assert.hasText(functionCode, "功能编码不能为空");
        MdmFunctionSubEntity mdmFunctionSubEntity = mdmFunctionSubService.lambdaQuery()
                .eq(MdmFunctionSubEntity::getFunctionType, MdmTableConfigFunctionTypeEnum.LIST_CONFIG.getCode())
                .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
                .one();
        Assert.notNull(mdmFunctionSubEntity, "列表配置不存在");
        String parentCode = mdmFunctionSubEntity.getParentCode();
        Assert.hasText(parentCode, "功能列表:"+functionCode+"菜单编码不能为空");
        return setListConfig(parentCode, functionCode, mdmFunctionSubEntity);
    }

    @Override
    public List<MdmColumnConfigBatchVo> formBatchQuery(List<MdmColumnConfigBatchVo> mdmColumnConfigBatchVos) {
        if(CollectionUtils.isEmpty(mdmColumnConfigBatchVos)){
            return new ArrayList<>();
        }
        return mdmColumnConfigBatchVos.stream().peek(x -> {
            MdmTableConfigReqVo mdmTableConfigReqVo = new MdmTableConfigReqVo();
            mdmTableConfigReqVo.setParentCode(x.getParentCode());
            mdmTableConfigReqVo.setFunctionCode(x.getFunctionCode());
            x.setMdmColumnConfigRespVos(formQuery(mdmTableConfigReqVo));
        }).collect(Collectors.toList());
    }
}





