package com.biz.crm.terminal.event.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.nebular.mdm.terminal.req.TerminalChangeHandlerReqVo;
import com.biz.crm.terminal.event.TerminalChangeEvent;
import com.biz.crm.terminal.handler.TerminalChangeHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

import java.util.List;

/**
 * 终端相关事件监听
 *
 * @author sunx
 * @date 2021/9/9
 */
@Component
@Slf4j
public class TerminalEventListener {

    /**
     * 终端信息变更实现
     */
    @Autowired(required = false)
    private List<TerminalChangeHandler> terminalChangeHandlers;

    @Async
    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT)
    public void onTerminalChangeEvent(TerminalChangeEvent event) {
        TerminalChangeHandlerReqVo vo = (TerminalChangeHandlerReqVo) event.getSource();
        log.info("终端信息改变事件监听:{}", JSON.toJSONString(vo));
        if (CollectionUtils.isNotEmpty(terminalChangeHandlers)) {
            terminalChangeHandlers.forEach(a -> a.handler(vo));
        }
        log.info("终端信息改变事件监听处理完成");
    }
}
