package com.biz.crm.terminal.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
public interface MdmTerminalSupplyMapper extends BaseMapper<MdmTerminalSupplyEntity> {

    /**
     * 条件查询
     *
     * @return java.util.List<com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSupplyRespVo>
     **/
    @SqlPrivilege(posCode = "b.position_code")
    List<MdmTerminalSupplyVo> listCondition(@Param("vo") MdmTerminalSupplyVo mdmTerminalSupplyVo);

    /**
     * 已关联客户的终端分页
     *
     * @param page                     page
     * @param mdmCustomerTerminalReqVo vo
     * @return list
     */
    @SqlPrivilege(orgCode = "org.org_code",posCode = "mt.position_code")
    List<MdmCustomerTerminalRespVo> correlatedCustomerPage(Page<MdmCustomerTerminalRespVo> page, @Param("vo") MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联任何客户的终端分页
     *
     * @param page                     page
     * @param mdmCustomerTerminalReqVo vo
     * @return list
     */
    @SqlPrivilege(
            orgCode = "d.org_code",
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a.terminal_code and position_code in"
    )
    List<MdmCustomerTerminalRespVo> uncorrelatedAnyCustomer(Page<MdmCustomerTerminalRespVo> page, @Param("vo") MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联当前客户的终端分页
     *
     * @param page                     page
     * @param mdmCustomerTerminalReqVo vo
     * @return list
     */
    @SqlPrivilege(
            orgCode = "d.org_code",
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a.terminal_code and position_code in"
    )
    List<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomer(Page<MdmCustomerTerminalRespVo> page, @Param("vo") MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 根据终端编码查询供货人列表
     *
     * @param terminalCode 终端编码
     * @return list
     */
    List<MdmTerminalSupplyVo> queryDetails(@Param("terminalCode") String terminalCode);

    /**
     * 查询供货关系
     *
     * @param mdmTerminalVo vo
     * @return list
     */
    List<MdmTerminalSupplyVo> findTerminalSupply(@Param("vo") MdmTerminalVo mdmTerminalVo);

    /**
     * 通过终端门店编码查询挂靠的客户信息
     * @param mdmTerminalSupplyVo
     * @return
     */
    List<MdmCustomerRespVo> findBySupply(@Param("vo") MdmTerminalSupplyVo mdmTerminalSupplyVo);
}
