package com.biz.crm.terminal.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;

import java.util.List;
import java.util.Map;

/**
 * @author ql
 * @date 2021/3/10
 * @time 9:32
 **/
public interface MdmTerminalElasticsearchService {

    /**
     * ec分页查询
     * 根据职位编码查询，并且根据经纬度计算出距离按照距离排序分页查询
     * 没有传递参数时，会按照默认的全局参数进行查询，如有需要，按照自己的分页参数查询
     * 如果需要某个条件下的所有数据，在某个条件下，将每页显示的记录条数变大，变得一页能装下即可，调用者注意数据量哦
     * @param pageReqVo 分页及查询参数
     * @return
     */
    PageResult<MdmTerminalCustomerElasticsearchRespVo> listWithPage(MdmTerminalCustomerElasticsearchPageReqVo pageReqVo);

    /**
     * 向es增加记录
     * 可以传递终端实体和客户实体，但是最终保存需要转换为同一实体
     * @param mdmTerminalVo 终端的
     * @param mdmCustomerMsgReqVo 客户的
     */
    void add(MdmTerminalVo mdmTerminalVo, MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 新增修改客户
     * @param mdmCustomerMsgReqVo vo
     */
    void add(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    void add(MdmTerminalVo mdmTerminalVo);

    void delete(List<String> ids);

    void reset();

    /**
     * 条件查询客户与终端
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictRespVo> listCondition(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 启用
     * @param ids id集合
     */
    void enable(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disable(List<String> ids);

    void updateByCodeList(List<String> codeList, Map<String, Object> map);

    /**
     * 根据id修改
     * @param id id
     * @param params 修改内容
     */
    void updateById(String id, Map<String, Object> params);
}
