package com.biz.crm.terminal.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;

import java.util.List;

/**
 * 终端图片接口
 *
 * @author zxw
 * @date 2020-11-23 11:53:06
 */
public interface MdmTerminalSupplyDetailService extends IService<MdmTerminalSupplyDetailEntity> {

    /**
     * 根据DataType 或者 关联id 查询集合
     *
     * @param supplyId
     * @param dataType
     * @return
     */
    List<MdmTerminalSupplyDetailEntity> getListBySupplyIdOrDataType(List<String> supplyId, String dataType);

    /**
     * 批量保存
     *
     * @param details
     */
    void saveList(List<MdmTerminalSupplyDetailVo> details);

    /**
     * 批量修改
     * @param details
     */
    void updateList(List<MdmTerminalSupplyDetailVo> details,String supplyId);

    /**
     * 批量删除
     * @param ids
     */
    void deleteBySupplyIds(List<String> ids);
}

