package com.biz.crm.terminal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;

import java.util.List;

/**
 * 联系人接口
 *
 * @author liaohua
 * @date 2020-09-02 14:10:26
 */
public interface MdmTerminalSupplyService extends IService<MdmTerminalSupplyEntity> {


    /**
     * 批量删除
     * @param terminalCodes
     */
    void deleteByCodes(List<String> terminalCodes);

    /**
     * 更新供货人
     * @param mdmTerminalVo vo
     */
    void setUpSupply(MdmTerminalVo mdmTerminalVo);

    /**
     * 根据终端查询供货关系
     * @param terminalCode 终端编码
     * @return
     */
    List<MdmTerminalSupplyVo> findByTerminalCode(String terminalCode);

    /**
     * 新增客户与终端关联
     * @param mdmCustomerCorrelatedTerminalReqVo vo
     */
    void customerRelationTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    /**
     * 已关联客户的终端分页
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> correlatedCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联任何客户的终端分页
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> unCorrelatedAnyCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联当前客户的终端分页
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 批量替换终端上级客户
     * @param mdmCustomerCorrelatedTerminalReplaceReqVo vo
     */
    void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo);

    /**
     * 根据客户编码和终端编码集合解除上级客户
     * @param mdmCustomerCorrelatedTerminalReqVo vo
     */
    void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    /**
     * 添加终端与职位的关联关系
     *
     * @param terminalCodeList
     * @param positionCode
     */
    void addTerminalPosition(List<String> terminalCodeList, String positionCode);

    void addTerminalPosition(List<String> terminalCodeList, String positionCode, String orgCode);

    /**
     * 通过ids删除关联关系
     * @param ids
     */
    void unbindByIds(List<String> ids);

    /**
     * 替换终端关联的职位
     *
     * @param ids
     * @param positionCode
     */
    void replaceRelationPosition(List<String> ids, String positionCode);

    void replaceRelationPosition(List<String> ids, String positionCode, String orgCode);

    /**
     * 根据客户编码查询终端编码
     * @param customerCodeList 客户编码集合
     * @return list
     */
    List<String> findTerminalByCustomer(List<String> customerCodeList);

    /**
     * 根据终端编码查询客户编码
     *
     * @param terminalCode
     * @return
     */
    List<String> findCustomerCodeListByTerminalCode(String terminalCode);

    /**
     * 根据职位编码查询查询对应终端编码
     * @param positionCodeList 职位编码集合
     * @return list
     */
    List<String> findTerminalByPositionCodeList(List<String> positionCodeList);

    /**
     * 根据终端查询供货关系
     * @param mdmTerminalVo vo
     * @return list
     */
    List<MdmTerminalSupplyVo> findTerminalSupply(MdmTerminalVo mdmTerminalVo);

    void addCustomerUserTerminalSupply(List<String> terminalCodeList, String userName);

    void delCustomerUserTerminalSupply(List<String> terminalCodeList, String userName);

    void replaceCustomerUserTerminalSupply(List<String> terminalCodeList, String userName, String newUserName);

    /**
     * 通过终端门店编码查询挂靠的客户信息
     * @param mdmTerminalSupplyVo
     * @return
     */
    List<MdmCustomerRespVo> findBySupply(MdmTerminalSupplyVo mdmTerminalSupplyVo);

    /**
     * 根据供货关系id查询产品层级信息
     * @param supplyId
     * @param dataType
     * @return
     */
    List<MdmTerminalSupplyDetailEntity> findGoodsLevelBySupplyId(String supplyId,String dataType);
}
