package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Liao Hua
 * @date 2020/9/7 4:29 下午
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmTerminalContactServiceExpandImpl")
public class MdmTerminalContactServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmTerminalContactMapper, MdmTerminalContactEntity> implements MdmTerminalContactService {


    @Override
    public void deleteByCodes(List<String> terminalCodes){
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.lambdaUpdate()
                .in(MdmTerminalContactEntity::getTerminalCode, terminalCodes)
                .remove();
    }

    @Override
    public void setUpContact(MdmTerminalVo mdmTerminalVo) {
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText(terminalCode, "终端编码不能为空");
        this.lambdaUpdate()
                .eq(MdmTerminalContactEntity::getTerminalCode, terminalCode)
                .remove();
        if (CollectionUtil.listEmpty(mdmTerminalVo.getContacts())) {
            return;
        }
        List<MdmTerminalContactVo> contacts = mdmTerminalVo.getContacts().stream()
                .filter(Objects::nonNull)
                .filter(item -> !StringUtils.isEmpty(item.getContactName())).collect(Collectors.toList());
        if (CollectionUtil.listEmpty(contacts)) {
            return;
        }
        long count = contacts.stream()
                .filter(x -> !StringUtils.isEmpty(x.getContactMain()) && x.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue()))
                .count();
        Assert.isTrue(count <= 1, "终端管理：主联系人只能有一个");
        Assert.isTrue(count == 1, "终端管理：主联系人必须有一个");
        for (MdmTerminalContactVo contact : contacts) {
            contact.setId(UUID.randomUUID().toString());
            contact.setTerminalCode(terminalCode);
        }
        this.saveBatch(CrmBeanUtil.copyList(contacts, MdmTerminalContactEntity.class));
    }

    @Override
    public List<MdmTerminalContactVo> findByTerminalCode(String terminalCode) {
        List<MdmTerminalContactEntity> list = this.lambdaQuery()
                .eq(MdmTerminalContactEntity::getTerminalCode, terminalCode)
                .list();
        return CrmBeanUtil.copyList(list, MdmTerminalContactVo.class);
    }

}
