package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitStatisticsTypeEnum;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalFormReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalFormRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalFormMapper;
import com.biz.crm.terminal.service.MdmTerminalFormService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author hx
 * @ClassName MdmTerminalFormServiceImpl
 * @Description
 * @date 2022/03/30
 */
@Service
public class MdmTerminalFormServiceImpl implements MdmTerminalFormService {

    @Resource
    private MdmTerminalFormMapper mdmTerminalFormMapper;

    @Override
    public PageResult<MdmTerminalFormRespVo> findList(MdmTerminalFormReqVo reqVo) {
        SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum visitStatisticsType = SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.getByCode(reqVo.getVisitStatisticsType());
        AssertUtils.isNotNull(visitStatisticsType, "未知的拜访查看类型");
        //暂存周数
        int week = 0;
        Integer month = 0;
        AssertUtils.isNotEmpty(reqVo.getQueryTime(), "请选择查询日期");
        if (visitStatisticsType != null) {
            Date parse = DateUtil.parse(reqVo.getQueryTime(), "yyyy-MM-dd");
            switch (visitStatisticsType) {
                case WEEK: {
                    //获取周一的日期
                    Date mondayDate = DateUtil.getFirstDayOfWeek(parse);
                    Calendar now = Calendar.getInstance();
                    now.setTime(mondayDate);
                    week = now.get(Calendar.WEEK_OF_MONTH);
                    //获取周天的日期
                    now.add(Calendar.DATE, 6);

                    String monday = DateUtil.getYYYYMMDD(mondayDate);
                    String sunday = DateUtil.getYYYYMMDD(now.getTime());
                    reqVo.setStartTime(monday);
                    reqVo.setEndTime(sunday);
                    reqVo.setQueryTime(reqVo.getQueryTime().substring(0, 7));
                    break;
                }
                case MONTH: {
                    reqVo.setQueryTime(reqVo.getQueryTime().substring(0, 7));
                    month = Integer.parseInt(reqVo.getQueryTime().substring(5, 7));
                    break;
                }
                default :
                    break;
            }
        }
        Page<MdmTerminalFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmTerminalFormRespVo> list =  mdmTerminalFormMapper.findList(page, reqVo);

        String weekStr = new StringBuilder("第" + week + "周").toString();
        for (MdmTerminalFormRespVo v : list) {
            v.setDate(reqVo.getQueryTime());
            if (visitStatisticsType == SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.WEEK) {
                v.setWeek(weekStr);
            }
            if (visitStatisticsType == SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.MONTH) {
                v.setMonth(month.toString());
            }
        }


        return PageResult.<MdmTerminalFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
}
