package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.user.req.MdmConsumerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmConsumerRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.user.service.MdmConsumerUserService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 用户信息表
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmConsumerUserController")
@CrmGlobalLog
@Api(tags = "MDM-用户管理（消费者用户）")
public class MdmConsumerUserController {

    @Autowired
    private MdmConsumerUserService mdmConsumerUserService;

    @Autowired
    private MdmUserService mdmUserService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserPageRespVo>> pageList(@RequestBody MdmCustomerUserPageReqVo reqVo) {
        PageResult<MdmCustomerUserPageRespVo> result = mdmConsumerUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmConsumerEditReqVo reqVo) {
        mdmConsumerUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "详情（消费用户）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "userName", value = "用户登录名", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmDictMethod
    public Result<MdmConsumerRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "userName", required = false) String userName) {
        return Result.ok(mdmConsumerUserService.query(id, userName));
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmConsumerEditReqVo reqVo) {
        mdmConsumerUserService.update(reqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmConsumerUserService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmUserService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmUserService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "用户解锁", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/unlock")
    public Result unlock(@RequestBody List<String> ids) {
        mdmUserService.unlock(ids);
        return Result.ok("解锁成功");
    }

    @ApiOperation(value = "解绑微信", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindWeChat")
    public Result unbindWeChat(@RequestBody List<String> ids) {
        mdmUserService.unbindWeChat(ids);
        return Result.ok("解绑成功");
    }

    @ApiOperation(value = "强制批量修改密码", httpMethod = "POST")
    @PostMapping("/forceChangePassword")
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        mdmUserService.forceChangePassword(reqVo);
        return Result.ok("修改成功");
    }

}
