package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserLoginLogReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户登录日志表
 *
 * @author Tao.Chen
 * @date 2021-03-18 21:38:20
 */
@Slf4j
@RestController
@RequestMapping("/mdmUserLoginLogController")
@Api(tags = "用户登录日志表")
public class MdmUserLoginLogController {

    @Autowired
    private MdmUserLoginLogService mdmUserLoginLogService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<MdmUserLoginLogRespVo>> list(@RequestBody MdmUserLoginLogReqVo reqVo) {
        PageResult<MdmUserLoginLogRespVo> result = mdmUserLoginLogService.findList(reqVo);
        return Result.ok(result);
    }

}
