package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationTerminalService;
import com.biz.crm.user.service.MdmUserRelationTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/mdmUserRelationTerminalController")
@Api(tags = "MDM-用户管理(企业用户)-关联终端")
@CrmGlobalLog
public class MdmUserRelationTerminalController {

    @Autowired
    private MdmUserRelationTerminalService mdmUserRelationTerminalService;
    @Autowired
    private MdmPositionRelationTerminalService mdmPositionRelationTerminalService;

    @ApiOperation(value = "查询未关联任何用户的终端")
    @PostMapping("/findTerminalNotRelateAnyUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationTerminalPageRespVo>> findTerminalNotRelateAnyUser(@RequestBody MdmUserRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmUserRelationTerminalService.findTerminalNotRelateAnyUser(reqVo));
    }

    @ApiOperation(value = "查询未关联当前用户的终端", notes = "userName必传")
    @PostMapping("/findTerminalNotRelateCurUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationTerminalPageRespVo>> findTerminalNotRelateCurUser(@RequestBody MdmUserRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmUserRelationTerminalService.findTerminalNotRelateCurUser(reqVo));
    }

    @ApiOperation(value = "查询已关联当前用户的终端", notes = "userName必传")
    @PostMapping("/findTerminalHasRelateCurUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationTerminalPageRespVo>> findTerminalHasRelateCurUser(@RequestBody MdmUserRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmUserRelationTerminalService.findTerminalHasRelateCurUser(reqVo));
    }

    @ApiOperation(value = "添加关联", notes = "传（terminalCodeList、positionCode）")
    @PostMapping("/bindRelation")
    public Result bindRelation(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        mdmPositionRelationTerminalService.bindRelation(reqVo.getTerminalCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "替换关联职位", notes = "传（ids、positionCode）")
    @PostMapping("/replaceTerminalPosition")
    public Result replaceTerminalPosition(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        mdmPositionRelationTerminalService.replaceTerminalPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "解除关联", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "关联关系id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindRelation")
    public Result unbindRelation(@RequestBody List<String> ids) {
        mdmPositionRelationTerminalService.unbindRelation(ids);
        return Result.ok();
    }

}
