package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.user.req.MdmUserUnderlingReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserUnderlingRespVo;
import com.biz.crm.user.service.MdmUserUnderlingService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户信息表
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmUserUnderlingController")
@Api(tags = "MDM-用户管理(企业用户)-下属")
@CrmGlobalLog
public class MdmUserUnderlingController {

    @Autowired
    private MdmUserUnderlingService mdmUserUnderlingService;

    @ApiOperation(value = "查询下属列表（分页）（userName必传）")
    @PostMapping("/findUserUnderlingList")
    @CrmDictMethod
    public Result<PageResult<MdmUserUnderlingRespVo>> findUserUnderlingList(@RequestBody MdmUserUnderlingReqVo reqVo) {
        PageResult<MdmUserUnderlingRespVo> result = mdmUserUnderlingService.findUserUnderlingList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation("下属-关联上级职位 传（underlingPositionCodeList、positionCode）")
    @PostMapping("/replaceParentPosition")
    public Result replaceParentPosition(@RequestBody MdmUserUnderlingReqVo reqVo) {
        mdmUserUnderlingService.replaceParentPosition(reqVo);
        return Result.ok();
    }


}
