package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.user.req.*;
import com.biz.crm.nebular.mdm.user.resp.*;
import com.biz.crm.user.model.MdmUserEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户信息表
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
public interface MdmCustomerUserMapper extends BaseMapper<MdmUserEntity> {

    /**
     * 列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(
            extOrgSql = "select 1 from MDM_CUSTOMER mc join MDM_CUSTOMER_R_ORG mo on mo.customer_code=mc.customer_code where mc.user_name = a.user_name and mo.org_code in",
            extPosSql = "select 1 from MDM_CUSTOMER mc join MDM_CUSTOMER_SUPPLY mo on mo.customer_code=mc.customer_code where mc.user_name = a.user_name and mo.POSITION_CODE in"
    )
    List<MdmCustomerUserPageRespVo> findList(Page<MdmCustomerUserPageRespVo> page, @Param("vo") MdmCustomerUserPageReqVo reqVo);

    /**
     * 查询未关联任何权限角色的客户用户列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelAnyRole(Page<MdmCustomerUserRelRolePageRespVo> page, @Param("vo") MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 查询未关联当前权限角色的客户用户列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelCurRole(Page<MdmCustomerUserRelRolePageRespVo> page, @Param("vo") MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 查询已关联当前权限角色的客户用户列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelRolePageRespVo> findCustomerUserHasRelCurRole(Page<MdmCustomerUserRelRolePageRespVo> page, @Param("vo") MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 查询未关联任何客户用户的终端列表（大范围：当前客户用户关联的客户下的终端）
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelAnyCustomerUser(Page<MdmCustomerUserRelTerminalPageRespVo> page, @Param("vo") MdmCustomerUserRelTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前客户用户的终端列表（大范围：当前客户用户关联的客户下的终端）
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelCurCustomerUser(Page<MdmCustomerUserRelTerminalPageRespVo> page, @Param("vo") MdmCustomerUserRelTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前客户用户的终端列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerUserRelTerminalPageRespVo> findTerminalHasRelCurCustomerUser(Page<MdmCustomerUserRelTerminalPageRespVo> page, @Param("vo") MdmCustomerUserRelTerminalPageReqVo reqVo);
}
