package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalDetailRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserPageRespVo;
import com.biz.crm.user.model.MdmUserEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 终端用户信息mapper
 * @author ql
 * @date 2021/2/3
 * @time 20:44
 **/
public interface MdmTerminalUserMapper extends BaseMapper<MdmUserEntity> {

    /**
     * 分页查询
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmTerminalUserPageRespVo> findList(Page<MdmTerminalUserPageRespVo> page, @Param("vo") MdmTerminalUserPageReqVo reqVo);


    /**
     * 按照条件查询终端集合
     * @param page 分页参数
     * @param reqVo 一些条件
     * @return 满足条件的集合
     */
    List<MdmTerminalDetailRespVo> getTerminalListByCondition(Page<MdmTerminalDetailRespVo> page,
                                                             @Param("vo") MdmTerminalUserTerminalSelectReqVo reqVo);
}
